import math

def dir_traj(route, pt, conv=False):
    
        try:
            ind = route.index(pt)
            if ind == 0:
                # print(f"{pt} is the first point of the trajectory, no correction to the yaw is needed")
                return 0

            prev_point = route[ind - 1]
            next_point = route[ind + 1] if ind + 1 < len(route) else route[ind]

            delta_x1, delta_y1 = route[ind][0] - prev_point[0], route[ind][1] - prev_point[1]
            prev_angle = math.atan2(delta_y1, delta_x1)

            delta_x2, delta_y2 = next_point[0] - route[ind][0], next_point[1] - route[ind][1]
            next_angle = math.atan2(delta_y2, delta_x2)

            dir_angle = prev_angle - next_angle

            if conv:
                return math.degrees(dir_angle)

            return dir_angle

        except ValueError:
            # print(f"{pt} does not belong to the list of coordinates, no correction to the yaw can be applied")
            return 0

        except IndexError:
            # print(f"{pt} is the last point of the trajectory, no correction to the yaw is needed")
            return 0
