import rclpy
from rclpy.node import Node
from geometry_msgs.msg import Point

class Myreader(Node):
    def __init__(self):
        super().__init__("clpt_reader")
        self.gps_subscriber = self.create_subscription(Point, '/gps', self.my_reader, 10)

    def my_reader(self, msg: Point):
        self.get_logger().info("The closest point is: " + str(msg))


def main(args=None):
    rclpy.init(args=args)
    node = Myreader()
    rclpy.spin(node)
    rclpy.shutdown()