import json
import matplotlib.pyplot as plt
import os

def createPlotWithThreshold(fileName, path, *thresholds):
    """
    Questa funzione accetta un numero variabile di threshold da plottare (caso: pronosupinazione con 2 soglie).
    Args:
    - fileName: Nome del file JSON da caricare.
    - path: Percorso della directory dei file JSON CALIBRATION, per creare path salvataggio plot.
    - *thresholds: Soglie da plottare come rette orizzontali.
    """
    
    baseFileName = os.path.splitext(fileName)[0]    # jsonOpen || togli .json 
    filePath = os.path.join(path, fileName)         # test/dataora/jsonOpen.json || per aprire la lista
    print(f"Lista valori analizzata: "+filePath)

    # parentDir = os.path.dirname(os.path.dirname(path))
    savePath = os.path.join(path, "plot_" + baseFileName + ".png") # # test/dataora/ "plot_" + jsonOpen +".png"

    # Carica i dati dal file JSON
    with open(filePath, 'r') as json_file:
        data = json.load(json_file)
    data = data['data']
    indices = list(range(1, len(data) + 1))    # Crea un indice per i dati
    plt.figure(figsize=(10, 6))    # Crea il grafico a dispersione con linee
    plt.plot(indices, data, marker='o', markersize=1, color='blue', linestyle='-', linewidth=1)

    for threshold in thresholds:    # Plotta le soglie come rette orizzontali
        plt.axhline(y=threshold, linestyle='--', label=f'soglia {threshold}')
    plt.xlabel('Frame')
    plt.ylabel('Distanza (u.a. Unity)')
    plt.title('Plot ' + baseFileName)
    plt.grid(True)
    plt.legend()

    plt.savefig(savePath)

### MAIN ###
dirPath = os.path.dirname(os.path.abspath(__file__)) # Percorso della directory del file JSON CONFIG
# Lettura del path jsonCalibration da jsonConfig 
jsonConfigPath = os.path.join(dirPath, "json_config.json")
try:
    with open(jsonConfigPath, 'r') as file:
        config_data = json.load(file)
        jsonCalibrationPath = config_data.get("jsonCalibrationPath")
        if jsonCalibrationPath is not None:
            print("Valore di jsonCalibrationPath:", jsonCalibrationPath)
        else:
            print("Campo jsonCalibrationPath non presente nel file JSON.")
except FileNotFoundError:
    print(f"Errore: Il file {jsonCalibrationPath} non è stato trovato.")
except json.JSONDecodeError:
    print(f"Errore: Impossibile decodificare il contenuto del file {jsonCalibrationPath}. Assicurati che sia un file JSON valido.")
except KeyError:
    print("Errore: Il campo jsonCalibrationPath non è presente nel file JSON.")
except Exception as e:
    print(f"Errore sconosciuto: {e}")

thresholdsFile = "json_calibration.json"

# Carica le soglie dal file JSON delle soglie
with open(os.path.join(jsonCalibrationPath, thresholdsFile), 'r') as thresholds_json_file:
    thresholds_data = json.load(thresholds_json_file)
thrOpen = thresholds_data['open']
thrTap = thresholds_data['tap']
thrPSDx = thresholds_data['PSDx']
thrPSSx = thresholds_data['PSSx']
# thrFEDx = thresholds_data['FEDx'] ### FE DISATTIVATA
# thrFESx = thresholds_data['FESx']

# Crea i grafici per i vari tipi di dati con le rette orizzontali corrispondenti alle soglie
createPlotWithThreshold("jsonOpen.json", jsonCalibrationPath, thrOpen)
createPlotWithThreshold("jsonTap.json", jsonCalibrationPath, thrTap)
createPlotWithThreshold("jsonPS.json", jsonCalibrationPath, thrPSSx, thrPSDx)
# createPlotWithThreshold("jsonFE.json", jsonCalibrationPath, thrFESx, thrFEDx) ### FE DISATTIVATA
