### EXERGAME ###
### main.py ###
'''
    Main script per effettuare hand tracking (landmark)
'''
import subprocess
import sys
import os

def listCameras():
    # Mostra tutte le telecamere disponibili
    for i in range(10):
        temp_cap = cv2.VideoCapture(i)
        if temp_cap.isOpened():
            print(f"Camera {i}: {temp_cap.get(cv2.CAP_PROP_FPS)} FPS")
            temp_cap.release()
        else:
            break

def findCamera():                           # Ricerca webcam da utilizzare (default: interna)
    for i in range(2): 
        temp_cap = cv2.VideoCapture(i)
        if temp_cap.isOpened():
            # if i != 0:
                print(f"- Telecamera esterna trovata: {i}")
                return temp_cap
        temp_cap.release()
    print("- Nessuna telecamera esterna trovata --> webcam del PC.")
    return cv2.VideoCapture(0)  # sorgente video: 0 = webcam del PC

def cameraResolution(cap):                  # Risoluzione sorgente video utilizzata
    if not cap.isOpened():
        print("\ncamResolution: Impossibile aprire la fotocamera!")
        with open(pathDebug, 'a') as debug_file:    # debug file
            debug_file.write("\ncamResolution: Impossibile aprire la fotocamera!")
        return
    width = int(cap.get(cv2.CAP_PROP_FRAME_WIDTH))
    height = int(cap.get(cv2.CAP_PROP_FRAME_HEIGHT))
    # with open(pathDebug, 'a') as debug_file:    # debug file
    #         debug_file.write(f"\ncamResolution: Risoluzione della fotocamera (width x height): {width}x{height}")
    # print(f"camResolution: Risoluzione della fotocamera (width x height): {width}x{height}")
    cap.set(3,width)          # imposta risoluzione webcam utilizzata
    cap.set(4,height)
    return width, height

def handCalibration(hand, ref_distances):   # Calcolo lista di ref_distances
    lmList = hand['lmList'] # get the landmark list 

    # Aggiungi il calcolo di distance e l'aggiornamento di ref_distances
    point0 = np.array(lmList[0][0:3])
    point17 = np.array(lmList[17][0:3])
    distance = np.linalg.norm(point0 - point17)
    ref_distances.append(distance)  # Aggiungi distance a ref_distances

    return ref_distances

def handRescale(hand, ref_distance):       # Rescale della mano
    # hand = hands[0] # get the first hand detected
    # print(f"Hand: {hand}")
    lmList = hand['lmList'] # get the landmark list 

    # print(f"Coordinate centro mano: {type(hand['center'])} , {hand['center'], {len(hand['center'])}}")
    # print(f"Mano: {hand['type']}")  # si può aggiungere {type(hand['type'])} 
    # print(f"BBox: {hand['bbox']}")

    # Calcolo della distanza effettiva tra i punti della mano
    point0 = np.array(lmList[0][0:3])    # converte il punto 0 in un array di NumPy
    point17 = np.array(lmList[17][0:3])  # converte il punto 17 in un array di NumPy
    distance = np.linalg.norm(point0 - point17)  # calcola la distanza tra i punti 0 e 17 utilizzando np.linalg.norm()

    scale_factor = ref_distance / distance # Calcolo del fattore di scala
    return scale_factor, hand

def install_package(package):
    subprocess.check_call([sys.executable, "-m", "pip", "install", package])

'''  Definizione percorsi '''
pathDir = os.path.dirname(os.path.abspath(__file__)) # path file JSON CONFIG
# filenameCalibration = "json_calibration.json"
filenameConfig = "json_config.json" 
nameDebugFile = "debugFile.txt"
pathDebug = os.path.join(pathDir, nameDebugFile)    # salva nella stessa cartella di json config
with open(pathDebug, 'w') as debug_file:
    debug_file.write('') # Svuota il file di debug

required_packages = ['cvzone', 'keyboard', 'numpy']#, 'mediapipe'] # Lista dei pacchetti necessari

for package in required_packages: # Verifica e installa i pacchetti mancanti
    try:
        __import__(package)        # Prova ad importare il pacchetto
        with open(pathDebug, 'a') as debug_file:    # debug file
            debug_file.write(f"\nInstallazione gia' effettuata di {package}")
        print(f"Installazione gia' effettuata di {package}")
    except ImportError:
        with open(pathDebug, 'a') as debug_file:    # debug file
            debug_file.write(f"\n{package} non installato. Installazione in corso...")
        print(f"\n{package} non installato. Installazione in corso...")
        install_package(package)    # installazione del pacchetto richiesto
        with open(pathDebug, 'a') as debug_file:    # debug file
            debug_file.write(f"\n{package} installato con successo!")
        print(f"\n{package} installato con successo!")

import cv2
from cvzone.HandTrackingModule import HandDetector
import socket
import numpy as np
import json
import mediapipe as mp
import time
import keyboard
import traceback

''' --- MAIN --- '''
start_time_webcam = time.time() # inizializzazione del timer per controllo apertura webcam

### Webcam ###
with open(os.path.join(pathDir, filenameConfig), 'r') as json_file:    # Carica contenuto del JSON config
    config_data = json.load(json_file)
    if 'webcamNum' in config_data:
        webcamNum = config_data['webcamNum']
    else:
        webcamNum = 0

### APERTURA WEBCAM
# cap = cv2.VideoCapture(0)     # old
cap = cv2.VideoCapture(webcamNum, cv2.CAP_DSHOW) # per risolvere bug! | old:  cv2.VideoCapture(0) | new: cv2.VideoCapture(0, cv2.CAP_DSHOW)
# cap.open(webcamNum, cv2.CAP_DSHOW)

# if cap.isOpened():
#     with open(pathDebug, 'a') as debug_file:    # debug file
#         debug_file.write(f"Webcam gia' aperta --> exit del nuovo server python (non aperto correttamente)")
#     cap.release()
#     exit()

width, height = cameraResolution(cap)
elapsed_time_webcam = time.time() - start_time_webcam
# print(f"---> Tempo trascorso dall'apertura webcam: {elapsed_time_webcam} secondi\n")
with open(pathDebug, 'a') as debug_file:    # debug file
    debug_file.write(f"\n---> Tempo trascorso dall'apertura webcam: {elapsed_time_webcam} secondi")

### Hand Detector ###
detector = HandDetector(maxHands=1, detectionCon=0.8)   # max num di mani rilevate (1,2), specificita' della detection (0,1)

### Communication ###
sock = socket.socket(socket.AF_INET, socket.SOCK_DGRAM) # UDP --> sock_dgram; TCP --> sock_stream
serverAddressPort = ("127.0.0.1", 8080)                 # server UDP, sulla porta 8080

# Inizializzazione per calcolo del frame rate reale
last_frame_time = time.time()
start_time = 0
spacePressed = False
first = True
printTimer = True

## LETTURA DA JSON DI REF_DISTANCE O INIZIALIZZAZIONE BASE
ref_distance = 80    # Inizializza ref_distance
timerCalibration = 7 # tempo di calibrazione di ogni task
try:    # inizializzazione timer
    with open(os.path.join(pathDir, filenameConfig), 'r') as json_config:
        config_data = json.load(json_config)
        if "timerCalibration" in config_data:  
            timerCalibration = float(config_data["timerCalibration"])
            # print(f"Valore di timerCalibration dal file JSON: {timerCalibration}")
    if timerCalibration < 3 or timerCalibration > 15:
            timerCalibration = 5
            # print("val di timerCalibration non valido --> impostato a 5 secondi!")
except:
    # print(f"Errore lettura timerCalibration!!")
    timerCalibration = 5
with open(pathDebug, 'a') as debug_file:    # debug file
    debug_file.write(f"\n---> timerCalibration e': {timerCalibration} secondi sul server python")
    printTimer = False

### LOOP --- HAND TRACKING ###
while True:
    with open(os.path.join(pathDir, filenameConfig), 'r') as json_file:    # Carica contenuto del JSON config
        config_data = json.load(json_file)

    if not cap.isOpened():  # debug error: webcam
        with open(pathDebug, 'a') as debug_file:
            debug_file.write("\nwhile: Impossibile aprire la webcam!")
        print("\nwhile: Impossibile aprire la webcam!")
        break
    success, img = cap.read()  # get the frame from the webcam
    if not success: # debug 
        try:
            raise Exception("while: Errore nella lettura del frame.")
        except Exception as e:
            with open(pathDebug, 'a') as debug_file:
                debug_file.write(f"\nwhile: Errore OpenCV: {str(e)}")
                debug_file.write(f"\nwhile: Errore di sistema OpenCV: {traceback.format_exc()}")
                print(f"while: Errore OpenCV: {str(e)}\n")
        break

    hands, img = detector.findHands(img)   # hands 
    img = cv2.flip(img, 1)                 # flip orizzontale
    # landmark values - (x, y, z)*21  numero totale di landmark

    # Inizializzazione posizione dei landmark, per ogni iterazione
    data = []   
    data_list = []

    # Visualizzazione frame rate reale
    # fps = cap.get(cv2.CAP_PROP_FPS) # Calcola il frame rate teorico
    current_time = time.time()      # Calcola il tempo trascorso da quando è stato catturato l'ultimo frame
    time_elapsed = current_time - last_frame_time   
    last_frame_time = current_time  # Aggiorna il tempo dell'ultimo frame con l'attuale tempo corrente
    real_fps = 1.0 / time_elapsed   # Calcola il frame rate reale
    # cv2.putText(img, f"frame rate: {real_fps:.2f}", (10, 30), cv2.FONT_HERSHEY_SIMPLEX, 0.6, (0, 0, 0), 2) # Aggiunge il testo del frame rate all'immagine

    if hands:    # hands contiene: lmList (21x3); bbox; center della mano; type DX-SX
        hand = hands[0]
        ### Rescale della mano
        scale_factor, hand = handRescale(hand, ref_distance)                  
        
        if hand['type'] == 'Right': # se mano utilizzata: destra
            handType = 'R'
        else:
            handType = 'L'

        if config_data.get('calibr') == 'true'and first == True and config_data.get('isActiveCalibration') == 'false':       # reinizializzazione flag
            if keyboard.is_pressed('space'):
                ref_distance = 80   # inizializzazione, prima del calcolo della ref distance effettiva dell'utente 
                with open(pathDebug, 'a') as debug_file:
                    debug_file.write(f"\n---> distanza di riferimento iniziale: {ref_distance}")
                start_time = time.time() # Inizia a misurare il tempo
                ref_distances = []  # Azzera la lista delle ref_distance
                print("Il tasto space e' stato premuto!")
                with open(pathDebug, 'a') as debug_file:
                    debug_file.write(f"\n---> Il tasto space e' stato premuto!")

            if start_time > 0:
                end_time = time.time()
                elapsed_time = end_time - start_time
                print(f"timer: {elapsed_time}")
                ref_distances = handCalibration(hand, ref_distances) # lista delle ref_distances
                if elapsed_time >= timerCalibration:  
                    if len(ref_distances) > 0: # Calcola la media delle ref_distance trovate
                        avg_ref_distance = sum(ref_distances) / len(ref_distances)
                        print(f"Media delle ref_distance: {avg_ref_distance}")   
                        with open(pathDebug, 'a') as debug_file:
                            debug_file.write(f"\n---> Media delle ref_distance: {avg_ref_distance}")  
                        ref_distance = int(avg_ref_distance) # aggiorna il valore di ref_distance dopo calibrazione
                        first = False
                    # Resetta le variabili
                    start_time = 0
                    end_time = 0
                    ref_distances = []
        if config_data.get('calibr') == 'false' and config_data.get('isActiveCalibration') == 'true' and first == False: ## RESET
            print(first)
            first = True
            print(f"Reset value: First: {first} e refDist: {ref_distance}")
            with open(pathDebug, 'a') as debug_file:
                    debug_file.write(f"\n---> Reset value: First: {first} e refDist: {ref_distance}")

        for lm in hand['lmList']:
            # salva i landmark come elementi di una singola lista
            data.extend([lm[0]* scale_factor, (height - lm[1])* scale_factor, lm[2]*scale_factor]) # 21 landmark x 3 assi = 63 coordinate
        data.extend([hand['center'][0], hand['center'][1]]) # centro della mano
        data.extend([height])   # dimensioni webcam - quintultimo elemento 
        data.extend([width])    # dimensioni webcam - quartultimo elemento 
        data.extend([handType])      # tipo di mano: destra o sinistra - terzultimo elemento
        data.extend([ref_distance])  # penultimo elemento di data --> data[-2]
        data.extend([scale_factor])  # per scalare le dimensioni della mano - ultimo elemento di data --> data[-1]
        # print((data))
        sock.sendto(str.encode(str(data)), serverAddressPort) # codifica dati e li invia alla porta specificata
                
    img = cv2.resize(img, (0, 0), None, 0.6, 0.6) # rescale (0,1)
    cv2.imshow("Image", img)

    if cv2.waitKey(1) & 0xFF == 27:  # "Esc" per uscire dal loop (ESC ASCII è 27)
        break

cap.release()
cv2.destroyAllWindows()

