classdef ScenarioRandom < handle
    properties
        stagione
        ev
        std
        distr %Poisson, Normal
    end
    
    methods
        function obj = ScenarioRandom(stagione, ev, std, distr)
            seasonalityRaw = stagione;
            obj.stagione = seasonalityRaw / mean(seasonalityRaw); % normalizzato in modo che sommino a 7
            obj.ev = obj.stagione * ev; % expected values with seasonality, assumed for any distr
            obj.distr = distr;
            
            if strcmp(obj.distr, 'Normal') % Normal distributed scenario requires the std
                obj.std = obj.stagione * std; % std values with seasonality
            end
        end
        
        % Specific seed reset
        function setSeed(obj, seed)
            rng(seed);
        end
        
        % Make scenario
        function scenarioDomanda = creaScenario(obj, orizzonteTemp) 
            scenarioDomanda = zeros(1, orizzonteTemp);
            for i = 1:orizzonteTemp
                giorno = mod(i-1, 7) + 1; % da 1 Lunedì a 7 Domenica
                if strcmp(obj.distr, 'Normal')
                    scenarioDomanda(i) = round(max(0, normrnd(obj.ev(giorno), obj.std(giorno))));
                elseif strcmp(obj.distr, 'Poisson')
                    scenarioDomanda(i) = round(poissrnd(obj.ev(dayWeek)));
                else
                    error('Distribuzione non disponibile');
                end
            end
            return
        end
    end
end