classdef Magazzino < handle
    properties
        inventario
        inTransito
        ordini
        leadTime
    end
    
    methods
        function obj = Magazzino(invIniziale, leadTime)
            obj.inventario = invIniziale;
            obj.ordini = [];
            obj.leadTime = leadTime;
            obj.inTransito = zeros(1, obj.leadTime);
        end
        
        function agg_Inv_InTrans(obj)
            % Aggiorniamo l'inventario e gli ordini in transito verso il
            % magazzino
            obj.inventario(end) = obj.inventario(end) + obj.inTransito(1);
            % Shiftiamo di un periodo gli ordini in transito
            obj.inTransito(1:end-1) = obj.inTransito(2:end);
            obj.inTransito(end) = 0;
        end

        function scarto = aggVita(obj)
            %Aggiorna l'inventario buttando i prodotti scaduti (fine
            %giornata)
            scarto = obj.inventario(1);
            obj.inventario(1:end-1) = obj.inventario(2:end); 
            obj.inventario(end) = 0;
            return
        end

        function emettiOrdine(obj, ordine)
            % Nuovo ordine da parte del magazzino
            obj.inTransito(end) = ordine;
        end

        function riceviOrdini(obj, ordini)
            % Ricezione degli ordini dai rivenditori ordinandoli da quello
            % con leadTime più grande
            obj.ordini = sortrows(ordini, 2, 'ascend');
        end

        function O = evadiOrdini(obj)
            % Evasione ordini verso i rivenditori (da caricare sul
            % Trasporto)
            v = length(obj.inventario); % Shelflife
            n = size(obj.ordini,1); % Numero rivenditori
            O = zeros(v,n);
            if sum(obj.ordini(:,1)) < sum(obj.inventario(obj.ordini(end,2)+1:end))
                % Se la somma degli ordini è inferiore alla somma dei
                % prodotti in inventario con tempo di vita rimasto maggiore
                % del leadTime minimo
                for i=1:n % Per ogni rivenditore                    
                    for j=obj.ordini(i,2)+1:v % Per ogni prodotto con vita > leadTime(j)
                        O(j,i) = O(j,i) + min(obj.ordini(i,1), obj.inventario(j));
                        obj.ordini(i,1) = obj.ordini(i,1) - O(j,i);
%                         if(~obj.ordini(i,1) || sum(obj.inventario(j:v))==0) % Se ho soddisfatto l'ordine
%                             break;
%                         end
                    end
                end
            else
                obj.ordini(:,1) = round(obj.ordini(:,1)/sum(obj.ordini(:,1)).*sum(obj.inventario(obj.ordini(end,2)+1:end)));
                for i=1:n
                    for j=obj.ordini(i,2)+1:v % Per ogni prodotto con vita > leadTime(j)
                        O(j,i) = O(j,i) + min(obj.ordini(i,1), obj.inventario(j)); % aggiungo i prodotti da spedire se ce ne sono con quella vita
                        obj.ordini(i,1) = obj.ordini(i,1) - O(j,i); % sottraggo al numero di prodotti ancora da soddisfare quelli appena aggiunti all'ordine
%                         if(~obj.ordini(i,1) || sum(obj.inventario(j:v))==0) % Se ho soddisfatto l'ordine
%                             break;
%                         end
                    end                    
                end
            end
            obj.inventario = obj.inventario - sum(O,2);
        end

    end
end