%% 
clear
clc
close
  
%%%RUN FIRST SECTION TO INITIALIZE SIMULATION PARAMETERS%%%%

m_c0 = 130; %kg
m_c = 130;
%https://demeter.cnes.fr/en/DEMETER/index.htm

 
%   Orbital elements

mu     = 3.986012*10^14;                                                    % [m^3/s^2]  Standard gravitational parameter
g0     = 9.81;                                                              % [m/s^2]    Zero gravity
r_E    = 6378.145*10^3;                                                     % [m]        Earth Radius
height = 715*10^3;                                                          % [m]        Reference altitude
r      = r_E + height;                                                      % [m]        Orbita Radius
omega  = (mu/r^3)^0.5;                                                      % [rad]      Target angular velocity
omega_0= (mu/r^3)^0.5;                                                      % [rad]      Target angular velocity
v      = sqrt(mu/r);                                                        % [m/s]      Tangential orbital speed
T      = 2*pi/omega;                                                        % [s]        Orbital Period

%%%SYSTEM dynamics
w = omega;
B = [zeros(3,3)
    eye(3,3)/m_c0];

phi = @(t) [1 0 6*(w*t-sin(w*t)) -3*t+(4/w)*sin(w*t) 0 (2/w)*(1-cos(w*t));
            0       cos(w*t)      0         0       sin(w*t)/w      0;
            0   0     4-3*cos(w*t)   (2/w)*(-1+cos(w*t))  0 sin(w*t)/w;
            0   0   6*w*(1-cos(w*t)) -3+(4*cos(w*t))    0      2*sin(w*t);
            0      -w*sin(w*t)    0        0      cos(w*t)   0 ;
            0       0      3*w*sin(w*t)  -2*sin(w*t)     0  cos(w*t)];
Bd =@(t) phi(t)*B;
Bdin =@(t) integral(Bd,0,t,"ArrayValued",1);

%   Initial conditions
Vx0  = v;                                                                   % [m/s]     Initial speed (only for study in inertial frame)
x0       = -200;                                                            % [m]      X position 
y0       = 0;                                                               % [m]      Y position 
z0       = 100;                                                               % [m]      Z position
x0_dot   = 3/2*omega_0*z0;%3/2*omega_0*z0;                                              % [m/s]    X speed 
y0_dot   = 0;                                                               % [m/s]    Y speed 
z0_dot   = 0;                                                               % [m/s]    Z speed

%%Thrusters model paramters

KF = 12.5*2;
tau = 1;
U_on = 0.75;
U_off = 0.2;
Umax = 2;


%%%Controller Parameters
lambda_top= 0.2;
lambda_low= 0.0001;
sigma_0 = 5e-4;
c = 1e-4;
G = c*(lambda_low-lambda_top)/(sigma_0);
k_x = 2;
k_y = 0.2;
k_z = 2;
K_v = 20;
alpha_x = 2;
alpha_y = 0.05;
alpha_z = 2;



%%Disturbs evaluation
lx = 60; %https://www.eoportal.org/satellite-missions/demeter
ly = 60;
lz = 85;

%Aerodynamic drag
rho = 4*10^(-13.5);                                                         % [kg/m^3] Air density obtained as medium value for 700 km orbit, ref Fehse
Vx  = omega*r;                                                              % [m/s]    Orbital velocity
CD  = 2.2;                                                                  % [--]     Drag coefficient for satellite of compact shapes
S   = ly*lz;                                                                % [m^2]    Cross section
F_D = -1/2*rho*CD*S*Vx^2;                                                   % [N]      Force due to the drag
%Mg = 3*wo^2*[(Izz-Iyy)*phi (Izz-Ixx)*theta 0]' 

%J2 effect 
J2 =1.08263e-6; 
Fj2= -m_c*((3*J2*mu*(r_E^2))/(2*(r^4)));                                    % [N]    Force due to J2



%%%HORIZON GUIDANCE PARAMETERS%%%%
updaterate = 2;
N = 20;
dt = 8;
dyn_s = 1e3;

PHI = phi(dt);
PHIB= Bdin(dt);

%%dynamical constraints
Aeq = zeros(6*N+3*(N-1),6*N+3*(N-1));
for i=1:N-1
    Aeq((6*i)+1 : (6*i)+6, 6*(i-1)+1:6*(i-1)+6 ) = PHI;
    Aeq((6*i)+1:(6*i)+6,6*i+1:(i*6)+6) = -eye(6,6);
    Aeq((6*i)+1:(6*i)+6,(N*6)+(i-1)*3+1:(N*6)+(i-1)*3+3) = PHIB;
end
Aeq(1:6,1:6) = eye(6,6);
