@load base/frameworks/logging
redef LogAscii::use_json=T;
redef LogAscii::json_timestamps=T;
redef LogAscii::json_extension=json;

@load base/frameworks/intel
@load protocols/conn/known-services

event zeek_init()
{
    LogAscii::open($path="zeek.log", LogAscii::JSON);
}

event conn(c: connection)
{
    if (c$id$orig_h == 172.16.0.1)
    {
        Log::write(LogAscii::JSON, [$fields=c$uid, $msg="Connessione sospetta da 172.16.0.1", $conn=c]);
    }
}