
from utility import configureKustomization, getFolderName, getServiceName
import ruamel.yaml
def generateClientYaml():
    serviceName = getServiceName()
    folderName=getFolderName()
    yaml_data=  {
        "apiVersion": "v1",
        "kind": "Pod",
        "metadata": {
            "name": "nsc",
            "labels": {
                "app": "alpine"
            },
            "annotations": {
                "networkservicemesh.io": f"kernel://{serviceName}/nsm-1"
            }
        },
        "spec": {
            "containers": [
                {
                    "name": "alpine",
                    "image": "alpine:3.15.0",
                    "imagePullPolicy": "IfNotPresent",
                    "command": ["/bin/sh", "-c", "trap : TERM INT; sleep infinity & wait"]
                }
            ],
            "affinity": {
                "podAffinity": {
                    "requiredDuringSchedulingIgnoredDuringExecution": [
                        {
                            "topologyKey": "kubernetes.io/hostname",
                            "labelSelector": {
                                "matchExpressions": [
                                    {
                                        "key": "app",
                                        "operator": "In",
                                        "values": ["nse-kernel"]
                                    }
                                ]
                            }
                        }
                    ]
                }
            }
        }
    }

    filename="client.yaml"
    with open(folderName+"/"+filename, "w") as yaml_file:
        ruamel.yaml.YAML().dump(yaml_data, yaml_file)
    configureKustomization(filename)