import click
from sfc_cli.functions import add_requirement, clear_requirements, remove_requirement, get_requirements, modify_requirement, setup, deploy


URL = "http://localhost:5000/api/upload_json"
@click.group(invoke_without_command=True)
def cli():
    """SFC is a cli useful to develop a security chain in the context of Kubernetes and NSM """
    if not click.get_current_context().invoked_subcommand:
        click.echo("SFC is a cli useful to develop a security chain in the context of Kubernetes and NSM")
        click.echo("Type --help to see how it works")


@cli.command()   
@click.argument('name')  
@click.option('--src', default=None, help='Source IP address')
@click.option('--p', default=None, help='Port number') 
def add(name, src, p):
    """Add a new specification for the chain """
    data = {'name': name}
    if src:
        data['src'] = src
    if p:
        data['p'] = [int(port) for port in p.split(',') if port.isdigit()]
    add_requirement(data)


@cli.command()
@click.argument('name')
@click.option('--field', help='Field to modify.')
@click.option('--newValue', 'new_value', help='New value to set for the specified field.')
def modify(name, field, new_value): 
    """Change the details of a specific specification """
    if not field or not new_value:
        click.echo("Both --field and --new-value options must be provided.")
        return
    modify_requirement(name, field, new_value)


@cli.command()
@click.option('--name', help='Name of the requirement to retrieve.')
def get(name=None):
    """Get the list of specifications."""
    get_requirements(name)


@cli.command()   
def clear(): 
    """Deletes all the specifications previously provided """
    clear_requirements()
    click.echo("Requirements deleted")



@cli.command()
@click.argument('name')    
def rm(name):
    """Remove a specification from the list """
    remove_requirement(name) 


@cli.command()
@click.argument('url')
def setchain(url):
    """Configure the requirements for the operator """
    setup(url)

@cli.command()
@click.argument('url')
def deploychain(url): 
    """Contacts the operator to deploy the chain specified """
    deploy(url)

if __name__ == "__main__":
    cli()

