import json
import os
import requests

filename= 'security_intents.json'
def add_requirement(data):
    #checks if the file already exists
    if os.path.exists(filename):
        with open(filename, 'r') as f:
            existing_data = json.load(f)
            for key, value in existing_data.items():
                if 'name' in value and value['name'] == data['name']:
                    print(f"Error: The name '{data['name']}' already exists. Please choose a different name.")
                    return
            
            last_index = max(int(key.replace("requirement", "")) for key in existing_data.keys() if key.startswith("requirement"))
            new_index = last_index + 1
    else:
        existing_data = {}
        new_index = 1

    existing_data[f"requirement{new_index}"] = data

    with open(filename, 'w') as f:
        json.dump(existing_data, f, indent=4)

def get_requirements(name=None):
    if not os.path.exists(filename):
        print(f"Error: '{filename}' does not exist.")
        return

    with open(filename, 'r') as f:
        data = json.load(f)

    if not data:
        print("No requirements found.")
        return
    if name:
        for key, value in data.items():
            if 'name' in value and value['name'].strip().lower() == name.strip().lower():
                print(f"Information for requirement '{name}':")
                print(json.dumps(value, indent=4))
                break
        else:
            print(f"Requirement '{name}' not found.")
    else:
        print("List of all requirements:")
        for key, value in data.items():
            print(f"{key}: {value}")


def remove_requirement(name):
    if not os.path.exists(filename):
        print(f"Error: '{filename}' does not exist.")
        return

    with open(filename, 'r') as f:
        data = json.load(f)

    requirement_to_delete = None
    for key, value in data.items():
        if 'name' in value and value['name'] == name:
            requirement_to_delete = key
            break

    if requirement_to_delete:
        del data[requirement_to_delete]
        with open(filename, 'w') as f:
            json.dump(data, f, indent=4)
        print(f"Requirement '{name}' has been deleted.")
    else:
        print(f"Error: Requirement named '{name}' not found.")



def clear_requirements():
    if os.path.exists(filename):
        os.remove(filename)
    else:
        print(f"'{filename}' does not exist.")


def modify_requirement(name, field, newValue):
    if not os.path.exists(filename):
        print(f"Error: you didn't specify any requirement yet.")
        return

    with open(filename, 'r') as f:
        data = json.load(f)

    found = False
    for key, value in data.items():
        if 'name' in value and value['name'] == name:

            if field in value:
                value[field] = newValue
                found = True
                break
            else:
                print(f"Error: Field '{field}' not found for requirement named '{name}'.")
                return

    if found:
        with open(filename, 'w') as f:
            json.dump(data, f, indent=4)
        print(f"'{field}' of requirement named '{name}' has been modified to '{newValue}'.")
    else:
        print(f"Error: Requirement named '{name}' not found.")


def setup(api_url):
    try:
        with open(filename, 'rb') as f:
            files = {'file': (filename, f)}
            response = requests.post(api_url, files=files)

        if response.status_code == 200:
            print("Setup successful")
        else:
            print(f"Error with API data. Response code: {response.status_code}")
            print(response.text)
    except Exception as e:
         print(f"An error occured during the send of data: {str(e)}")  

def deploy(url):
    response = requests.get(url)
    if response.status_code == 200:
        print('Deployment successful!')
    else:
        print(f'Deployment failed with status code: {response.status_code}')
    