import json

def save_answers(data, filename="specifications.json"):
    with open(filename, 'w') as f:
        json.dump(data, f, indent=4)

def main():
    answers = {}
    print("Welcome! You are asked to provide the desired specifications: insert them 1 by 1.")
    print("If you need more details type -h or -help to receive more information")
    print("At the end type exit to save the changes")
    counter = 1
    
    while True:
      
        answer = input(f"Specification number {counter}:")

     
        if answer.lower() == 'exit':
            print("Done")
            save_answers(answers)
            break
        
        details = []
        while True:
            detail = input("Provide your details and type done when you finish or none to move to the next specification: ")
            if detail.lower() == 'done' or detail.lower() == 'none':
                break
            details.append(detail)
      
    
        key = f"specification{counter}"
        answers[key] = {
            "requirement":answer,
            "details": details}
      
        counter += 1  

if __name__ == "__main__":
    main()
