# SFC CLI (Security Chain for Kubernetes and NSM)

The SFC CLI is a command-line tool designed for developing security chains within the context of Kubernetes and NSM (Network Service Mesh). It provides a set of commands to manage security chain specifications and interact with a Kubernetes operator for deployment.

## Installation

To use the SFC CLI, you need to have Python installed. You can install the CLI and its dependencies using pip.
Clone the project and then move into the sfc_cli folder.
Type the following command:

```bash
pip install -r requirements.txt
```

```bash
cd sfc_cli
```

```bash
pip install -e .
```
At this point the requirements are installed as weel as the CLI package. In this way, it is possible to apply some changes to the code of the CLI without installing again the package. 
## Usage
General Usage
```bash
sfc [OPTIONS] COMMAND [ARGS]...
```
```bash
sfc add <name> [--src <src>] [--p <p>]
```
Add a new specification for the security chain.

```bash
sfc modify <name> --field <field> --newValue <new_value>
```
Change the details of a specific specification.


```bash
sfc get [--name <name>]
```
Get the list of specifications.

```bash
sfc clear
```
Deletes all the specifications previously provided.

```bash
sfc rm <name>
```
Remove a specification from the list.

 ```bash
sfc setchain <url>
```
Configure the requirements for the Kubernetes operator.
.
```bash
sfc deploychain <url>
```
Contact the Kubernetes operator to deploy the specified security chain.


## Example of Usage

# Add a new specification
    sfc add my-spec --src 192.168.1.1 --p 80,443

# Modify an existing specification
    sfc modify my-spec --field src --newValue 192.168.2.2

# Get the list of specifications
    sfc get

# Delete all specifications
    sfc clear

# Remove a specific specification
    sfc rm my-spec

# Configure requirements for the operator
    sfc setchain http://localhost:28900/api/upload_json

# Deploy the specified security chain
    sfc deploychain http://localhost:28900/api/deploy

