library ieee;
use ieee.std_logic_1164.all;
use ieee.numeric_std.all;
use work.curve_parameter_pkg.all;

entity tb_shift_reg2 is
end entity;

architecture structural of tb_shift_reg2 is


signal data_in : std_logic_vector(9 downto 0);
signal data_out : std_logic_vector(11 downto 0);
signal start, clock, shift : std_logic;


 component shift_reg2 is
     generic( n: integer);
     port ( data_in : in std_logic_vector( n-1 downto 0);
            clock, en, reset, shift: in std_logic; --reset active high, en enable the loading, shift enable the shift
            data_out : out std_logic_vector(n+1 downto 0));
 end component;

begin

data_in <= "0011101101"; -- test with 10 bit for better understanding
start <= '0', '1' after 35 ns, '0' after 55 ns;
shift <= '0', '1' after 50 ns;

clk: process
begin
clock <= '0', '1' after 10 ns;
wait for 20 ns;
end process;



comp: shift_reg2 generic map ( n => 10)
                port map ( data_in, clock, start, '0',shift, data_out );

end architecture;
