library ieee;
use ieee.std_logic_1164.all;
use ieee.numeric_std.all;
use work.curve_parameter_pkg.all;

entity tb_precomputation_RADIX4 is
end entity;

architecture structural of tb_precomputation_RADIX4 is


signal A : std_logic_vector(255 downto 0);
signal A_out, Ax2, Ax3 : std_logic_vector(257 downto 0);
signal start, clock, shift : std_logic;


 component precomputation_RADIX4 is
    port( A : in std_logic_vector(255 downto 0);
          clock, reset, start : in std_logic;          --reset active high 
          A_out, Ax2, Ax3 : out std_logic_vector(257 downto 0)); 
 end component;

begin

A <= x"12036cee2b6ffe738cc740797779e89800700a4d4141d8ab75eb4dca135978a3";
start <= '0', '1' after 35 ns, '0' after 55 ns;
shift <= '0', '1' after 50 ns;

clk: process
begin
clock <= '0', '1' after 10 ns;
wait for 20 ns;
end process;



comp: precomputation_RADIX4 port map ( A, clock, '0', start, A_out, Ax2, Ax3  );

--results are correct and compared with MATLAB results

end architecture;
