library ieee;
use ieee.std_logic_1164.all;
use ieee.numeric_std.all;
use work.curve_parameter_pkg.all;

entity tb_point_doubling_RADIX4 is
end entity;

architecture structural of tb_point_doubling_RADIX4 is


signal x1, y1, z1, x2, y2, z2, correct_x2, correct_y2, correct_z2 : std_logic_vector(255 downto 0);
signal clock, reset, start, done : std_logic;

 component point_doubling_RADIX4 is
    port( x1, y1, z1 : in std_logic_vector(255 downto 0);
          clock, reset, start : in std_logic;          --reset active high 
          done : out std_logic;
          x2,y2,z2 : out std_logic_vector( 255 downto 0));
 end component;

begin

-- input value and result are taken by a paper 
x1 <= x"216936d3cd6e53fec0a4e231fdd6dc5c692cc7609525a7b2c9562d608f25d51a";
y1 <= x"6666666666666666666666666666666666666666666666666666666666666658";
z1 <= x"0000000000000000000000000000000000000000000000000000000000000001";

reset <= '0', '1' after 10 ns, '0' after 15 ns;
start <= '0', '1' after 25 ns, '0' after 45 ns; -- testing cyclic working 

clk: process
begin
clock <= '0', '1' after 10 ns;
wait for 20 ns;
end process;

correct_x2<= x"31241ddb9a7c254aea224b87b7b0f909886ec1ddfa71625b7aba864c18300a57";
correct_y2<= x"3324984c6cc933db69b782fc3ac951f60a47aa662bbe321c924b2cd95e2d7fd7";
correct_z2<= x"6986c5796b577c574098d1fa3b426292ebd36100339299d16374a93d0278de6b";

comp: point_doubling_RADIX4 port map (x1, y1, z1, clock, reset, start, done, x2, y2, z2);

end architecture;
