library ieee;
use ieee.std_logic_1164.all;
use ieee.numeric_std.all;
use work.curve_parameter_pkg.all;

entity tb_point_addition_RADIX4 is
end entity;

architecture structural of tb_point_addition_RADIX4 is


signal x1, x2, y1, y2, z1, z2, x3, y3, z3, correct_x3, correct_y3, correct_z3 : std_logic_vector(255 downto 0);
signal clock, reset, start, done : std_logic;

 component point_addition_RADIX4 is

    port( x1, x2, y1, y2, z1, z2 : in std_logic_vector(255 downto 0);
          clock, reset, start : in std_logic;          --reset active high 
          done : out std_logic;
          x3,y3,z3 : out std_logic_vector( 255 downto 0));

 end component;

begin

-- input value and result are taken by a paper 
x1 <= x"216936d3cd6e53fec0a4e231fdd6dc5c692cc7609525a7b2c9562d608f25d51a";
y1 <= x"6666666666666666666666666666666666666666666666666666666666666658";
z1 <= x"0000000000000000000000000000000000000000000000000000000000000001";
x2 <= x"31241ddb9a7c254aea224b87b7b0f909886ec1ddfa71625b7aba864c18300a57";
y2 <= x"3324984c6cc933db69b782fc3ac951f60a47aa662bbe321c924b2cd95e2d7fd7";
z2 <= x"6986c5796b577c574098d1fa3b426292ebd36100339299d16374a93d0278de6b";
reset <= '0', '1' after 10 ns, '0' after 15 ns;
start <= '0', '1' after 25 ns, '0' after 45 ns, '1' after 10495 ns, '0' after 10515 ns; -- testing cyclic working 

clk: process
begin
clock <= '0', '1' after 10 ns;
wait for 20 ns;
end process;

correct_x3<= x"6b8e2fbc776b7e13ce4aa95335c6b1f390a06b8f524baf4ec23753b1c9eb9985";
correct_y3<= x"169a317c0cbfff7865588ce7671602170b9df112a9f752eedf75f68803ec7664";
correct_z3<= x"61e9be98a68f5565e79965b0c47b14857cbd699b053f91018b5f4b631d02d8e9";

comp: point_addition_RADIX4 port map (x1, x2, y1, y2, z1, z2, clock, reset, start, done, x3, y3, z3);

end architecture;
