library ieee;
use ieee.std_logic_1164.all;
use ieee.numeric_std.all;
use work.curve_parameter_pkg.all;

entity tb_mux16to1_1_modified is
end entity;

architecture structural of tb_mux16to1_1_modified is


signal in_0, in_1, in_2, in_3, in_4, data_out : std_logic_vector(3 downto 0);
signal sel : std_logic_vector (3 downto 0);


 component mux16to1_1_modified is
    generic( n : integer);
    port( in_0, in_1, in_2, in_3, in_4 : in std_logic_vector(n-1 downto 0);
          sel : in std_logic_vector(3 downto 0);
          data_out : out std_logic_vector(n-1 downto 0));
 end component;


begin

in_0 <= x"a";
in_1 <= x"b";
in_2 <= x"c";
in_3 <= x"d";
in_4 <= x"e";
sel <= "0000", "0001" after 1 ns, "0010" after 2 ns, "0011" after 3 ns, "0100" after 4 ns, "0101" after 5 ns, "0110" after 6 ns, "0111" after 7 ns, "1000" after 8 ns,
 "1001"  after 9 ns, "1010" after 10 ns, "1011" after 11 ns, "1100" after 12 ns, "1101" after 13 ns, "1110" after 14 ns, "1111" after 15 ns;

comp: mux16to1_1_modified  generic map (n => 4)
                           port map ( in_0, in_1, in_2, in_3, in_4, sel, data_out );

end architecture;
