library ieee;
use ieee.std_logic_1164.all;
use ieee.numeric_std.all;
use work.curve_parameter_pkg.all;

entity tb_modular_sum is
end entity;

architecture structural of tb_modular_sum is


signal a_in, b_in, s_out, p_val : std_logic_vector(255 downto 0);
signal sum_correct_res : std_logic_vector(255 downto 0);
signal done, start, clock, as_sel : std_logic;


 component modular_sum is
    port( A,B : in std_logic_vector(255 downto 0);
          clock, reset, start : in std_logic;          --reset active high 
          sum_out : out std_logic_vector(255 downto 0);
          done : out std_logic); 
 end component;

begin

---- ATTENTION : a_in e b_in must be less than p ----
                                                                                   ------ WORST CASE, both equal to max value --> p-1 -----
a_in <= x"3B4F7D4346362AF8A89ED3A1571717143B403120E23AA6C3EDF08130B04B4E65"; -- x"7FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFEC" after 95 ns;
b_in <= x"7FFFFFFFFFC1DC930962FB1E43CF45CA32159A70D56796FD45906A4F59580F5A"; -- x"7FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFEC" after 95 ns;
start <= '0', '1' after 35 ns, '0' after 55 ns;

clk: process
begin
clock <= '0', '1' after 10 ns;
wait for 20 ns;
end process;

comp: modular_sum port map ( a_in, b_in, clock,'0',start, s_out, done );

p_val <= p;

--------CORRECT result computated in MATLAB --------
sum_correct_res <= x"3B4F7D4345F8078BB201CEBF9AE65CDE6D55CB91B7A23DC13380EB8009A35DD2", x"7FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFEB" after 100 ns;

end architecture;