library ieee;
use ieee.std_logic_1164.all;
use ieee.numeric_std.all;
use work.curve_parameter_pkg.all;

entity tb_modular_sub is
end entity;

architecture structural of tb_modular_sub is


signal a_in, b_in, s_out, p_val : std_logic_vector(255 downto 0);
signal sub_correct_res : std_logic_vector(255 downto 0);
signal done, start, clock : std_logic;


 component modular_sub is
    port( A,B : in std_logic_vector(255 downto 0);
          clock, reset, start : in std_logic;          --reset active high 
          sum_out : out std_logic_vector(255 downto 0);
          done : out std_logic); 
 end component;

begin

---- ATTENTION : a_in e b_in must be less than p ----
--a_in <= x"3B4F7D4346362AF8A89ED3A1571717143B403120E23AA6C3EDF08130B04B4E65", x"12036cee2b6ffe738cc740797779e89800700a4d4141d8ab75eb4dca135978a3" after 95 ns;
--b_in <= x"7FFFFFFFFFC1DC930962FB1E43CF45CA32159A70D56796FD45906A4F59580F5A", x"216936D3CD6E53FEC0A4E231FDD6DC5C692CC7609525A7B2C9562D608F25D51A" after 95 ns;
a_in <= x"1805DDB3491DF0A9558E2EBBAA02855EFFA18262F5201AA14F4661759BD03577";
b_in <= x"0000000000000000000000000000000000000000000000000000000000000002";
start <= '0', '1' after 35 ns, '0' after 55 ns, '1' after 95 ns, '0' after 115 ns;

clk: process
begin
clock <= '0', '1' after 10 ns;
wait for 20 ns;
end process;


comp: modular_sub port map ( a_in, b_in, clock,'0',start, s_out, done );

p_val <= p;

--------CORRECT result computated in MATLAB --------
sub_correct_res <= x"3B4F7D4346744E659F3BD8831347D14A092A96B00CD30FC6A86016E156F33EF8", x"709A361A5E01AA74CC225E4779A30C3B974342ECAC1C30F8AC9520698433A376" after 100 ns;

end architecture;
