library ieee;
use ieee.std_logic_1164.all;
use ieee.numeric_std.all;
use work.curve_parameter_pkg.all;

entity tb_modular_RADIX4_precomp is
end entity;

architecture structural of tb_modular_RADIX4_precomp is


signal A, B, res_out, correct_res : std_logic_vector(255 downto 0);
signal start, reset, clock, shift, done : std_logic;


 component modular_mult_RADIX4_precomp is
    port( A,B : in std_logic_vector(255 downto 0);
          clock, reset, start, shift : in std_logic;          --reset active high 
          mult_out : out std_logic_vector(255 downto 0);
          done : out std_logic); 
 end component;

begin

A <= x"12036cee2b6ffe738cc740797779e89800700a4d4141d8ab75eb4dca135978a3";
B <= x"216936D3CD6E53FEC0A4E231FDD6DC5C692CC7609525A7B2C9562D608F25D51A";
start <= '0', '1' after 35 ns, '0' after 55 ns;
shift <= '0', '1' after 50 ns;
reset <= '0', '1' after 15 ns, '0' after 20 ns;

clk: process
begin
clock <= '0', '1' after 10 ns;
wait for 20 ns;
end process;



comp: modular_mult_RADIX4_precomp port map ( A, B, clock, reset, start, shift, res_out, done );



correct_res<= std_logic_vector((unsigned(A(255 downto 0)) * unsigned(B)) mod(unsigned(p)) );  -- correct result for comparison

end architecture;
