library ieee;
use ieee.std_logic_1164.all;
use ieee.numeric_std.all;
use work.curve_parameter_pkg.all;

entity tb_modular_mult_RADIX2 is
end entity;

architecture structural of tb_modular_mult_RADIX2 is


signal a_in, b_in, mult_out, correct_res : std_logic_vector(255 downto 0);
signal clock, reset, start, shift, done : std_logic;

 component modular_mult_RADIX2 is
    port( A,B : in std_logic_vector(255 downto 0);
          clock, reset, start, shift : in std_logic;          --reset active high -- if as_sel=1 -> SUB, if as_sel=0 -> ADD
          mult_out : out std_logic_vector(255 downto 0);
          done : out std_logic); 
 end component;

begin

a_in <= x"12036cee2b6ffe738cc740797779e89800700a4d4141d8ab75eb4dca135978a3";
b_in <= x"216936D3CD6E53FEC0A4E231FDD6DC5C692CC7609525A7B2C9562D608F25D51A";

---WORST CASE ---
--a_in <= x"7FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFEC";
--b_in <= x"7FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFEC";

reset <= '0', '1' after 10 ns, '0' after 15 ns;
start <= '0', '1' after 25 ns, '0' after 45 ns;
shift <= '0', '1' after 45 ns;

clk: process
begin
clock <= '0', '1' after 10 ns;
wait for 20 ns;
end process;

correct_res<= std_logic_vector((unsigned(a_in) * unsigned(b_in)) mod(unsigned(p)) );  -- correct result for comparison

comp: modular_mult_RADIX2 port map ( a_in,b_in,clock, reset, start, shift, mult_out, done);

end architecture;
