library ieee;
use ieee.std_logic_1164.all;
use ieee.numeric_std.all;
use work.curve_parameter_pkg.all;

entity tb_modular_inverter is
end entity;

architecture structural of tb_modular_inverter is


signal B, inv_out, correct_res : std_logic_vector(255 downto 0);
signal clock, reset, start, done : std_logic;

 component modular_inverter is
    port( B : in std_logic_vector(255 downto 0);
          clock, reset, start : in std_logic;          --reset active high 
          inv_out : out std_logic_vector(255 downto 0);
          done : out std_logic);
 end component;

begin

B <= x"12036cee2b6ffe738cc740797779e89800700a4d4141d8ab75eb4dca135978a3";
-- test with enter = 7 and fixing p=11 the result expected is 8
--B <= "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000111";

-- WORSRT CASE --
         
--B <= "000111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111101100";

reset <= '0', '1' after 10 ns, '0' after 15 ns;
start <= '0', '1' after 25 ns, '0' after 45 ns;

clk: process
begin
clock <= '0', '1' after 10 ns;
wait for 20 ns;
end process;

correct_res<= x"3B096388255DB31880D26F49D83D9129118727536B2C8ADFAB2CB245C2BC67E4";  -- correct result for comparison computed with python code

comp: modular_inverter port map ( B, clock, reset, start, inv_out, done);

end architecture;
