library ieee;
use ieee.std_logic_1164.all;
use ieee.numeric_std.all;
use work.curve_parameter_pkg.all;

entity tb_counter is
end entity;

architecture structural of tb_counter is


signal clock, reset, en: std_logic;
signal count : std_logic_vector (7 downto 0);


component Counter is
    Port ( clock, reset, en : in std_logic;
           count : out std_logic_vector(7 downto 0));
end component;


begin

reset <= '0', '1' after 10 ns, '0' after 15 ns;
en <= '1';

clk: process
begin
clock <= '0', '1' after 10 ns;
wait for 20 ns;
end process;

cnt: counter port map ( clock, reset, en, count );

end architecture;
