library ieee;
use ieee.std_logic_1164.all;
use ieee.numeric_std.all;
use work.curve_parameter_pkg.all;

entity tb_OR_256bit is
end entity;

architecture structural of tb_OR_256bit is


signal data_in : std_logic_vector(255 downto 0);
signal data_out : std_logic;


component OR_256bit is
    Port ( input_bits : in STD_LOGIC_VECTOR(255 downto 0);
           or_output : out STD_LOGIC);
end component;


begin

data_in <= x"12036cee2b6ffe738cc740797779e89800700a4d4141d8ab75eb4dca135978a3",              x"216936D3CD6E53FEC0A4E231FDD6DC5C692CC7609525A7B2C9562D608F25D51A" after 10 ns,
           x"0000000000000000000001000000000000000000000000000000000000000000" after 15 ns,  x"0000000000000000000000000000000000000000000000000000000000000000" after 20 ns;

comp: OR_256bit port map ( data_in, data_out );

end architecture;
