library ieee;
use ieee.std_logic_1164.all;
use ieee.numeric_std.all;
use work.curve_parameter_pkg.all;

entity tb_ECPM_projective_to_affine is
end entity;

architecture structural of tb_ECPM_projective_to_affine is


signal K, x, y : std_logic_vector(255 downto 0);
signal clock, reset, start, done : std_logic;

 component ECPM_projective_to_affine is

    port( K : in std_logic_vector(255 downto 0);
          clock, reset, start : in std_logic;          --reset active high 
          done : out std_logic;
          x, y : out std_logic_vector( 255 downto 0));

 end component;

begin

-- input value PRIVATE KEY
K <= x"f9ab30f9f6e0db3d6a254bca6d272be910f5616da13e1f6707298f25e13e94b5";

reset <= '0', '1' after 10 ns, '0' after 15 ns;
start <= '0', '1' after 25 ns, '0' after 45 ns;

clk: process
begin
clock <= '0', '1' after 10 ns;
wait for 20 ns;
end process;


comp: ECPM_projective_to_affine port map (K, clock, reset, start, done, x, y);

end architecture;
