library ieee;
use ieee.std_logic_1164.all;
use ieee.numeric_std.all;
use work.curve_parameter_pkg.all;

entity tb_ECPM_RADIX2 is
end entity;

architecture structural of tb_ECPM_RADIX2 is


signal K, Qx, Qy, Qz, correct_Qx, correct_Qy, correct_Qz : std_logic_vector(255 downto 0);
signal clock, reset, start, done : std_logic;

 component ECPM_RADIX2 is
    port( K : in std_logic_vector(255 downto 0);
          clock, reset, start : in std_logic;          --reset active high 
          done : out std_logic;
          Qx, Qy, Qz : out std_logic_vector( 255 downto 0));
 end component;

begin

-- input value PRIVATE KEY
K <= x"f9ab30f9f6e0db3d6a254bca6d272be910f5616da13e1f6707298f25e13e94b5";

reset <= '0', '1' after 10 ns, '0' after 15 ns;
start <= '0', '1' after 25 ns, '0' after 45 ns;

clk: process
begin
clock <= '0', '1' after 10 ns;
wait for 20 ns;
end process;

--result are computated with a Matlab simulator verified with a java code
correct_Qx<= x"29ECABFBD1E39AAA5DD78829146D4EC74206BB28C886256E5C213F3080CE2095";
correct_Qy<= x"4704A8F2EF7592DDEF13BDCD474490FB1CA8A4661892BA50773452F68FF4614C";
correct_Qz<= x"480472383562FAAE60C678EB912565D5964A3943C70A27BC093362072DC9E92F";

comp: ECPM_RADIX2 port map (K, clock, reset, start, done, Qx, Qy, Qz);

end architecture;
