library ieee;
use ieee.std_logic_1164.all;
use ieee.numeric_std.all;

entity tb_CLA_257_cout is
end entity;

architecture structural of tb_CLA_257_cout is


signal a_in, b_in, s_nocout, correct_res_noCout : std_logic_vector(256 downto 0);
signal  correct_res, scout : std_logic_vector(257 downto 0);
signal c_in, c_out : std_logic;


component CLA_257bit is 

    port( a_in,b_in : in std_logic_vector( 256 downto 0);
          c_in : in std_logic;
          s : out std_logic_vector( 256 downto 0));

end component;

begin

a_in <= "00111011010011110111110101000011010001100011101100010101011111000101010001001111011010011101000010101011100010111000101110001010000111011010000000011000100100000111000100011101010100110110000111110110111110000100000010011000010110000010010110100111001100101";
b_in <= "11000101010111101001101111110010001110010010111011111001000011001011000100000011010011010111110010011100010110000010010010111010111010000000101110001101111001100000010111110101100011011010100001010001000101010100011101111101001001101011011110001101111111000";
c_in <= '0', '1' after 10 ns;

correct_res_noCout <= std_logic_vector(unsigned(a_in) + unsigned(b_in));  -- correct result for comparison without carry out
correct_res <= std_logic_vector(unsigned('0' & a_in) + unsigned('0' & b_in));

comp: CLA_257bit port map ( a_in, b_in, c_in, s_nocout);
scout <= c_out & s_nocout;

end architecture;
