library ieee;
use ieee.std_logic_1164.all;
use ieee.numeric_std.all;

entity tb_CLA_256bit is
end entity;

architecture structural of tb_CLA_256bit is


signal a_in, b_in, s, correct_res : std_logic_vector(255 downto 0);
signal c_in, g_out, p_out : std_logic;

component CLA_256bit is 

    port( a_in,b_in : in std_logic_vector( 255 downto 0);
          c_in : in std_logic;
          g_out, p_out : out std_logic;
          s : out std_logic_vector( 255 downto 0));

end component;

begin

a_in <= x"12036cee2b6ffe738cc740797779e89800700a4d4141d8ab75eb4dca135978a3";
b_in <= x"216936D3CD6E53FEC0A4E231FDD6DC5C692CC7609525A7B2C9562D608F25D51A";
c_in <= '0', '1' after 10 ns;

correct_res <= std_logic_vector(unsigned(a_in) + unsigned(b_in));  -- correct result for comparison 

comp: CLA_256bit port map ( a_in,b_in,c_in,g_out, p_out, s);

end architecture;
