library ieee;
use ieee.std_logic_1164.all;
use ieee.numeric_std.all;

-- this shift register is on n bit in which the lsb is '1' -- (256 bit & '1')

 entity shift_reg2 is
     generic( n: integer);
     port ( data_in : in std_logic_vector( n-1 downto 0);
            clock, en, reset, shift: in std_logic; --reset active high, en enable the loading, shift enable the shift
            data_out : out std_logic_vector(n+1 downto 0));
 end entity;

 architecture behavioural of shift_reg2 is

signal mux1_in0, mux1_in1, mux1_out, reg1_out : std_logic_vector(n+1 downto 0);
signal not_start, reg_en : std_logic;

 component reg is
     generic( n: integer);
     port ( data_in : in std_logic_vector( n-1 downto 0);
            clock, en, reset: in std_logic; --reset attivo alto
            data_out : out std_logic_vector( n-1 downto 0));
 end component;

 component mux2to1 is
    generic(n : integer);
    port( in_0, In_1 : in std_logic_vector (n-1 downto 0);
          sel: in std_logic;
          data_out : out std_logic_vector (n-1 downto 0));
 end component;

 begin

mux1_in0 <= data_in & "01";
mux1_in1 <= reg1_out(n-1 downto 0) & "00";

not_start <= not(en);

mux1: mux2to1 generic map( n+2 )
              port map(mux1_in0, mux1_in1, not_start, mux1_out);

reg_en <= en or shift;

reg1: reg generic map( n+2 )
          port map( mux1_out, clock, reg_en, reset, reg1_out);

data_out <= reg1_out;



 end architecture;
