library ieee;
use ieee.std_logic_1164.all;
use ieee.numeric_std.all;
use work.curve_parameter_pkg.all;

 entity precomputation_RADIX4 is

    port( A : in std_logic_vector(255 downto 0);
          clock, reset, start : in std_logic;          --reset active high 
          A_out, Ax2, Ax3 : out std_logic_vector(257 downto 0)); 

 end entity;

 architecture behavioural of precomputation_RADIX4 is

signal reg1_out : std_logic_vector(255 downto 0);
signal A_out0, A2 : std_logic_vector(257 downto 0);

 component reg is
     generic( n: integer);
     port ( data_in : in std_logic_vector( n-1 downto 0);
            clock, en, reset: in std_logic;                 --reset active high
            data_out : out std_logic_vector( n-1 downto 0));
 end component;

component CLA_258bit is  --------- 259 BIT input/output ---------
    port( a_in,b_in : in std_logic_vector( 257 downto 0);
          c_in : in std_logic;
          s : out std_logic_vector( 257 downto 0));
end component;

begin

reg1: reg generic map ( n => 256 )
          port map ( A , clock, start, reset, reg1_out );

A_out0 <= '0' & '0'& reg1_out;
A_out  <= A_out0;
A2     <= '0' & reg1_out & '0';
Ax2    <= A2;

s1: CLA_258bit port map (A2, A_out0, '0', Ax3);


 end architecture;
