library ieee;
use ieee.std_logic_1164.all;
use ieee.numeric_std.all;
use work.curve_parameter_pkg.all;

 entity point_doubling_RADIX4 is

    port( x1, y1, z1 : in std_logic_vector(255 downto 0);
          clock, reset, start : in std_logic;          --reset active high 
          done : out std_logic;
          x2,y2,z2 : out std_logic_vector( 255 downto 0));

 end entity;

 architecture behavioural of point_doubling_RADIX4 is

signal done_pd, reset_pd : std_logic;
signal mux1_sel, mux2_sel, mux3_sel, mux4_sel, mux5_sel, mux6_sel, mux7_sel, mux8_sel, mux9_sel, mux10_sel : std_logic;
signal shift, start_m1, start_m2, start_m3, start_m4, start_a1, start_a2, start_s1, start_s2 : std_logic;
signal reset_m1, reset_m2, reset_m3, reset_m4, reset_a1, reset_a2, reset_s1, reset_s2 : std_logic;
signal reg1_load, reg2_load, reg3_load, reg4_load : std_logic;
signal done_L1, done_L2, done_L3, done_L4 : std_logic;


 component point_doubling_RADIX4_datapath is

    port( x1, y1, z1 : in std_logic_vector(255 downto 0);
          clock, reset, start : in std_logic;          --reset active high 
          x2, y2, z2 : out std_logic_vector( 255 downto 0);
          mux1_sel, mux2_sel, mux3_sel, mux4_sel, mux5_sel, mux6_sel, mux7_sel, mux8_sel, mux9_sel, mux10_sel : in std_logic;
          shift, start_m1, start_m2, start_m3, start_m4, start_a1, start_a2, start_s1, start_s2 : in std_logic;
          reset_m1, reset_m2, reset_m3, reset_m4, reset_a1, reset_a2, reset_s1, reset_s2 : in std_logic;
          reg1_load, reg2_load, reg3_load, reg4_load : in std_logic;
          done_L1, done_L2, done_L3, done_L4 : out std_logic);

 end component;

component point_doubling_RADIX4_fsm is

port(     clock, reset, start : in std_logic;          --reset active high 
          done_pd, reset_pd : out std_logic;
          mux1_sel, mux2_sel, mux3_sel, mux4_sel, mux5_sel, mux6_sel, mux7_sel, mux8_sel, mux9_sel, mux10_sel : out std_logic;
          shift, start_m1, start_m2, start_m3, start_m4, start_a1, start_a2, start_s1, start_s2 : out std_logic;
          reset_m1, reset_m2, reset_m3, reset_m4, reset_a1, reset_a2, reset_s1, reset_s2 : out std_logic;
          reg1_load, reg2_load, reg3_load, reg4_load : out std_logic;
          done_L1, done_L2, done_L3, done_L4 : in std_logic);

end component;

  begin

datapath : point_doubling_RADIX4_datapath port map ( x1, y1, z1, clock, reset_pd, start, x2, y2, z2, mux1_sel, mux2_sel, mux3_sel, mux4_sel, mux5_sel,
           mux6_sel, mux7_sel, mux8_sel, mux9_sel, mux10_sel, shift, start_m1, start_m2, start_m3, start_m4, start_a1, start_a2, start_s1, start_s2, 
          reset_m1, reset_m2, reset_m3, reset_m4, reset_a1, reset_a2, reset_s1, reset_s2, reg1_load, reg2_load, reg3_load, reg4_load, done_L1, done_L2,
           done_L3, done_L4);

fsm : point_doubling_RADIX4_fsm port map (clock, reset, start, done_pd, reset_pd, mux1_sel, mux2_sel, mux3_sel, mux4_sel, mux5_sel, mux6_sel, mux7_sel,
           mux8_sel, mux9_sel, mux10_sel, shift, start_m1, start_m2, start_m3, start_m4, start_a1, start_a2, start_s1, start_s2, reset_m1, reset_m2,
           reset_m3, reset_m4, reset_a1, reset_a2, reset_s1, reset_s2, reg1_load, reg2_load, reg3_load, reg4_load, done_L1, done_L2, done_L3, done_L4);

done <= done_pd;

 end architecture;
