library ieee;
use ieee.std_logic_1164.all;
use ieee.numeric_std.all;

entity point_doubling_RADIX2_fsm is

port(     clock, reset, start : in std_logic;          --reset active high 
          done_pd, reset_pd : out std_logic;
          mux1_sel, mux2_sel, mux3_sel, mux4_sel, mux5_sel, mux6_sel, mux7_sel, mux8_sel, mux9_sel, mux10_sel : out std_logic;
          shift, start_m1, start_m2, start_m3, start_m4, start_a1, start_a2, start_s1, start_s2 : out std_logic;
          reset_m1, reset_m2, reset_m3, reset_m4, reset_a1, reset_a2, reset_s1, reset_s2 : out std_logic;
          reg1_load, reg2_load, reg3_load, reg4_load : out std_logic;
          done_L1, done_L2, done_L3, done_L4 : in std_logic);

end entity;

architecture structural of point_doubling_RADIX2_fsm is

-------machine state----------
type state_type is (IDLE,L1_A,L1_B,L2_A,L2_B,L3_A,L3_B,L4_A,L4_B,DONE); --stati
signal present_state, next_state: state_type; --stato corrente, stato futuro

--..............................................SIGNAL.......................................................

--there are no signal because there is only the fsm and there is not the datapath inside this block

--.............................................COMPONENT.....................................................

--there are no component because there is only the fsm and there is not the datapath inside this block

--.................................................FSM........................................................
 begin

------------state update-------------
update_state: process(clock, reset)
begin

 if reset='1' then present_state <= IDLE;  --reset active high
 elsif (clock'event and clock='1') then present_state <= next_state;
 end if;

end process;

---------state transition------------
state_transition: process(clock, present_state)
begin
case present_state is

 when IDLE => if start = '1' then next_state <= L1_A; else next_state <= IDLE; end if;
 when L1_A => next_state <= L1_B;
 when L1_B => if done_L1 = '1' then next_state <= L2_A; else next_state <= L1_B; end if;
 when L2_A => next_state <= L2_B;
 when L2_B => if done_L2 = '1' then next_state <= L3_A; else next_state <= L2_B; end if;
 when L3_A => next_state <= L3_B;
 when L3_B => if done_L3 = '1' then next_state <= L4_A; else next_state <= L3_B; end if;
 when L4_A => next_state <= L4_B;
 when L4_B => if done_L4 = '1' then next_state <= DONE; else next_state <= L4_B; end if;
 when DONE => next_state <= IDLE;


end case;
end process;

---------------output-------------
output: process(present_state)
begin
 
--default value signal control
done_pd <= '0'; reset_pd <= '0'; mux1_sel <= '0'; mux2_sel <= '0';  mux3_sel <= '0'; mux4_sel  <= '0';
mux5_sel <= '0'; mux6_sel <= '0'; mux7_sel <= '0'; mux8_sel <= '0'; mux9_sel <= '0'; mux10_sel <= '0';
shift <= '0'; start_m1 <= '0'; start_m2 <= '0'; start_m3 <= '0'; start_m4 <= '0'; start_a1 <= '0'; start_a2 <= '0'; start_s1 <= '0'; start_s2 <= '0';
 reg1_load <= '0'; reg2_load <= '0'; reg3_load <= '0'; reg4_load <= '0';
 reset_m1 <= '0'; reset_m2 <= '0'; reset_m3 <= '0'; reset_m4 <= '0'; reset_a1 <= '0'; reset_a2 <= '0'; reset_s1 <= '0'; reset_s2 <= '0';

--definition signal transition for each state, only the signal that switch
case present_state is

 when IDLE => reset_pd <= '1' ; reset_m1 <= '1'; reset_m2 <= '1'; reset_m3 <= '1'; reset_m4 <= '1'; reset_a1 <= '1'; reset_a2 <= '1'; reset_s1 <= '1'; reset_s2 <= '1';

 when L1_A => mux1_sel <= '0'; mux2_sel <= '0';  mux3_sel <= '0'; mux4_sel  <= '0'; mux5_sel <= '0'; mux6_sel <= '0'; mux7_sel <= '0'; mux8_sel <= '0';
              mux9_sel <= '0'; mux10_sel <= '0';
              start_m1 <= '1'; start_m2 <= '1'; start_m3 <= '1'; start_m4 <= '1'; start_a1 <= '0'; start_a2 <= '0'; start_s1 <= '0'; start_s2 <= '0';
 when L1_B => shift <= '1';
 
 when L2_A => mux1_sel <= '0'; mux2_sel <= '0';  mux3_sel <= '0'; mux4_sel  <= '0'; mux5_sel <= '0'; mux6_sel <= '0'; mux7_sel <= '0'; mux8_sel <= '0';
              mux9_sel <= '0'; mux10_sel <= '0';
              start_m1 <= '0'; start_m2 <= '0'; start_m3 <= '0'; start_m4 <= '0'; start_a1 <= '1'; start_a2 <= '1'; start_s1 <= '1'; start_s2 <= '1'; reg4_load <= '1';
 when L2_B => shift <= '0';

 when L3_A => mux1_sel <= '0'; mux2_sel <= '0';  mux3_sel <= '0'; mux4_sel  <= '0'; mux5_sel <= '0'; mux6_sel <= '0'; mux7_sel <= '1'; mux8_sel <= '1';
              mux9_sel <= '1'; mux10_sel <= '1'; reg1_load <= '1'; reg2_load <= '1'; reg3_load <= '1';
              start_m1 <= '0'; start_m2 <= '0'; start_m3 <= '0'; start_m4 <= '0'; start_a1 <= '0'; start_a2 <= '1'; start_s1 <= '0'; start_s2 <= '1';
 when L3_B => shift <= '0';

 when L4_A => mux1_sel <= '1'; mux2_sel <= '1';  mux3_sel <= '1'; mux4_sel  <= '1'; mux5_sel <= '1'; mux6_sel <= '1'; mux7_sel <= '0'; mux8_sel <= '0';
              mux9_sel <= '0'; mux10_sel <= '0';
              start_m1 <= '1'; start_m2 <= '1'; start_m3 <= '1'; start_m4 <= '0'; start_a1 <= '0'; start_a2 <= '0'; start_s1 <= '0'; start_s2 <= '0';
 when L4_B => shift <= '1' ;

 when DONE => done_pd <= '1';


end case;
end process;
 
--..............................................DATAPATH.......................................................

--there are no datapath connection because there is only the fsm and there is not the datapath inside this block
      
                  
end architecture;
