library ieee;
use ieee.std_logic_1164.all;
use ieee.numeric_std.all;
use work.curve_parameter_pkg.all;

 entity point_doubling_RADIX2_datapath is

    port( x1, y1, z1 : in std_logic_vector(255 downto 0);
          clock, reset, start : in std_logic;          --reset active high 
          x2, y2, z2 : out std_logic_vector( 255 downto 0);
          mux1_sel, mux2_sel, mux3_sel, mux4_sel, mux5_sel, mux6_sel, mux7_sel, mux8_sel, mux9_sel, mux10_sel : in std_logic;
          shift, start_m1, start_m2, start_m3, start_m4, start_a1, start_a2, start_s1, start_s2 : in std_logic;
          reset_m1, reset_m2, reset_m3, reset_m4, reset_a1, reset_a2, reset_s1, reset_s2 : in std_logic;
          reg1_load, reg2_load, reg3_load, reg4_load : in std_logic;
          done_L1, done_L2, done_L3, done_L4 : out std_logic);

 end entity;

 architecture behavioural of point_doubling_RADIX2_datapath is

signal  mux1_in0, mux1_in1 , mux1_out : std_logic_vector(255 downto 0);
signal  mux2_in0, mux2_in1 , mux2_out : std_logic_vector(255 downto 0);
signal  mux3_in0, mux3_in1 , mux3_out : std_logic_vector(255 downto 0);
signal  mux4_in0, mux4_in1 , mux4_out : std_logic_vector(255 downto 0);
signal  mux5_in0, mux5_in1 , mux5_out : std_logic_vector(255 downto 0);
signal  mux6_in0, mux6_in1 , mux6_out : std_logic_vector(255 downto 0);
signal  mux7_in0, mux7_in1 , mux7_out : std_logic_vector(255 downto 0);
signal  mux8_in0, mux8_in1 , mux8_out : std_logic_vector(255 downto 0);
signal  mux9_in0, mux9_in1 , mux9_out : std_logic_vector(255 downto 0);
signal  mux10_in0, mux10_in1 ,mux10_out : std_logic_vector(255 downto 0);
signal  mult1_out, mult2_out, mult3_out, mult4_out, add1_out, add2_out, sub1_out, sub2_out : std_logic_vector (255 downto 0);
signal A1,B1,A2,B2,A3,B3,A4,B4,A5,B5,A6,B6,A7,B7,A8,B8 : std_logic_vector(255 downto 0);
signal done_m1, done_m2, done_m3, done_m4, done_a1, done_a2, done_s1, done_s2 : std_logic;
signal reg4_out, reg3_out, reg2_out, reg1_out : std_logic_vector(255 downto 0);



 component mux4to1 is
    generic( n : integer);
    port( in_00, in_01, in_10, in_11 : in std_logic_vector(n-1 downto 0);
          sel : in std_logic_vector(1 downto 0);
          data_out : out std_logic_vector(n-1 downto 0));
 end component;

 component mux2to1 is
    generic(n : integer);
    port( in_0, In_1 : in std_logic_vector (n-1 downto 0);
          sel: in std_logic;
          data_out : out std_logic_vector (n-1 downto 0));
 end component;

 component reg is
     generic( n: integer);
     port ( data_in : in std_logic_vector( n-1 downto 0);
            clock, en, reset: in std_logic;                 --reset active high
            data_out : out std_logic_vector( n-1 downto 0));
 end component;

 component flip_flop is
     port ( data_in : in std_logic;
            clock, en, reset: in std_logic; --reset attivo alto
            data_out : out std_logic);
 end component;

component modular_sub is
    port( A,B : in std_logic_vector(255 downto 0);
          clock, reset, start : in std_logic;          --reset active high 
          sum_out : out std_logic_vector(255 downto 0);
          done : out std_logic); 
 end component;

 component modular_sum is
    port( A,B : in std_logic_vector(255 downto 0);
          clock, reset, start : in std_logic;          --reset active high 
          sum_out : out std_logic_vector(255 downto 0);
          done : out std_logic); 
 end component;

 component modular_mult_RADIX2 is
    port( A,B : in std_logic_vector(255 downto 0);
          clock, reset, start, shift : in std_logic;          --reset active high 
          mult_out : out std_logic_vector(255 downto 0);
          done : out std_logic); 
 end component;

  begin

---  MULT1 & mux1 & mux2

mux1_in0 <= y1;
mux1_in1 <= reg1_out;
mux1: mux2to1 generic map (n => 256)
              port map ( mux1_in0, mux1_in1, mux1_sel, mux1_out);

mux2_in0 <= y1;
mux2_in1 <= reg2_out;
mux2: mux2to1 generic map (n => 256)
              port map ( mux2_in0, mux2_in1, mux2_sel, mux2_out);

A1 <= mux1_out;
B1 <= mux2_out;
mult1 : modular_mult_RADIX2 port map (A1, B1, clock, reset_m1, start_m1, shift, mult1_out, done_m1);

reg1: reg generic map ( n => 256 )
          port map ( add1_out , clock, reg1_load, reset, reg1_out );

reg2: reg generic map ( n => 256 )
          port map ( sub1_out , clock, reg2_load, reset, reg2_out );

y2 <= mult1_out;


---  MULT2 & mux3 & mux3

mux3_in0 <= x1;
mux3_in1 <= reg3_out;
mux3: mux2to1 generic map (n => 256)
              port map ( mux3_in0, mux3_in1, mux3_sel, mux3_out);

mux4_in0 <= x1;
mux4_in1 <= sub2_out;
mux4: mux2to1 generic map (n => 256)
              port map ( mux4_in0, mux4_in1, mux4_sel, mux4_out);

A2 <= mux3_out;
B2 <= mux4_out;
mult2 : modular_mult_RADIX2 port map (A2, B2, clock, reset_m2, start_m2, shift, mult2_out, done_m2);

reg3: reg generic map ( n => 256 )
          port map ( sub2_out , clock, reg3_load, reset, reg3_out );

z2 <= mult2_out;


---  MULT3 & mux5 & mux6

mux5_in0 <= z1;
mux5_in1 <= sub2_out;
mux5: mux2to1 generic map (n => 256)
              port map ( mux5_in0, mux5_in1, mux5_sel, mux5_out);

mux6_in0 <= z1;
mux6_in1 <= add2_out;
mux6: mux2to1 generic map (n => 256)
              port map ( mux6_in0, mux6_in1, mux6_sel, mux6_out);

A3 <= mux5_out;
B3 <= mux6_out;
mult3 : modular_mult_RADIX2 port map (A3, B3, clock, reset_m3, start_m3, shift, mult3_out, done_m3);

x2 <= mult3_out;


---  MULT4 

A4 <= x1;
B4 <= y1;
mult4 : modular_mult_RADIX2 port map (A4, B4, clock, reset_m4, start_m4, shift, mult4_out, done_m4);

reg4: reg generic map ( n => 256 )
          port map ( mult4_out , clock, reg4_load, reset, reg4_out );

---  ADD1

A5 <= mult1_out;
B5 <= mult2_out;
add1 : modular_sum port map (A5, B5, clock, reset_a1, start_a1, add1_out, done_a1);

---  ADD2 & mux9 & mux10

mux9_in0 <= mult3_out;
mux9_in1 <= reg4_out;
mux9: mux2to1 generic map (n => 256)
              port map ( mux9_in0, mux9_in1, mux9_sel, mux9_out);

mux10_in0 <= mult3_out;
mux10_in1 <=  reg4_out;
mux10: mux2to1 generic map (n => 256)
              port map ( mux10_in0, mux10_in1, mux10_sel, mux10_out);

A6 <= mux9_out;
B6 <= mux10_out;
add2 : modular_sum port map (A6, B6, clock, reset_a2, start_a2, add2_out, done_a2);


---  SUB1

A7 <= mult2_out;
B7 <= mult1_out;
sub1 : modular_sub port map (A7, B7, clock, reset_s1, start_s1, sub1_out, done_s1);


---  SUB2 & mux7 & mux8

mux7_in0 <= mult1_out;
mux7_in1 <= sub2_out;
mux7: mux2to1 generic map (n => 256)
              port map ( mux7_in0, mux7_in1, mux7_sel, mux7_out);

mux8_in0 <= mult2_out;
mux8_in1 <=  add2_out;
mux8: mux2to1 generic map (n => 256)
              port map ( mux8_in0, mux8_in1, mux8_sel, mux8_out);

A8 <= mux7_out;
B8 <= mux8_out;
sub2 : modular_sub port map (A8, B8, clock, reset_s2, start_s2, sub2_out, done_s2);

--- LEVEL DONE ---

done_L1 <= done_m1 and done_m2 and done_m3 and done_m4;
done_L2 <= done_a1 and done_s1 and done_s2 and done_a2;
done_L3 <= done_s2 and done_a2;
done_L4 <= done_m1 and done_m2 and done_m3;

 end architecture;
