library ieee;
use ieee.std_logic_1164.all;
use ieee.numeric_std.all;
use work.curve_parameter_pkg.all;

 entity point_addition_RADIX4_datapath is

    port( x1, x2, y1, y2, z1, z2 : in std_logic_vector(255 downto 0);
          clock, reset, start : in std_logic;          --reset active high 
          x3,y3,z3 : out std_logic_vector( 255 downto 0);
          mux1_sel, mux2_sel, mux3_sel, mux4_sel : in std_logic_vector(1 downto 0);
          mux5_sel, mux6_sel, mux7_sel, mux8_sel, mux9_sel, mux10_sel, mux11_sel, mux12_sel, mux13_sel, mux14_sel : in std_logic;
          shift, start_m1, start_m2, start_m3, start_m4, start_m5, start_s1, start_as1, as1_sel : in std_logic;
          reset_m1, reset_m2, reset_m3, reset_m4, reset_m5, reset_s1, reset_as1 : in std_logic;
          reg1_load, reg2_load, reg3_load, cnt_reset, cnt_en : in std_logic;
          done_L1, done_L2, done_L3, done_L4, done_L5 : out std_logic;
          count : out std_logic_vector(7 downto 0));

 end entity;

 architecture behavioural of point_addition_RADIX4_datapath is

signal  mux1_in00, mux1_in01 , mux1_in10, mux1_in11, mux1_out : std_logic_vector(255 downto 0);
signal  mux2_in00, mux2_in01 , mux2_in10, mux2_in11, mux2_out : std_logic_vector(255 downto 0);
signal  mux3_in00, mux3_in01 , mux3_in10, mux3_in11, mux3_out : std_logic_vector(255 downto 0);
signal  mux4_in00, mux4_in01 , mux4_in10, mux4_in11, mux4_out : std_logic_vector(255 downto 0);
signal  mux5_in0, mux5_in1 ,mux5_out : std_logic_vector(255 downto 0);
signal  mux6_in0, mux6_in1 ,mux6_out : std_logic_vector(255 downto 0);
signal  mux7_in0, mux7_in1 ,mux7_out : std_logic_vector(255 downto 0);
signal  mux8_in0, mux8_in1 ,mux8_out : std_logic_vector(255 downto 0);
signal  mux9_in0, mux9_in1 ,mux9_out : std_logic_vector(255 downto 0);
signal  mux10_in0, mux10_in1 ,mux10_out : std_logic_vector(255 downto 0);
signal  mux11_in0, mux11_in1 ,mux11_out : std_logic_vector(255 downto 0);
signal  mux12_in0, mux12_in1 ,mux12_out : std_logic_vector(255 downto 0);
signal  mux13_in0, mux13_in1 ,mux13_out : std_logic_vector(255 downto 0);
signal  mux14_in0, mux14_in1 ,mux14_out : std_logic_vector(255 downto 0);
signal  mult1_out, mult2_out, mult3_out, mult4_out, mult5_out, add_1_out, add_sub_1_out : std_logic_vector (255 downto 0);
signal A1,B1,A2,B2,A3,B3,A4,B4,A5,B5,A6,B6,A7,B7 : std_logic_vector(255 downto 0);
signal done_m1, done_m2, done_m3, done_m4, done_m5, done_s1, done_as1 : std_logic;
signal reg3_out, reg2_out, reg1_out : std_logic_vector(255 downto 0);
signal ff4_out, ff5_out : std_logic;



 component mux4to1 is
    generic( n : integer);
    port( in_00, in_01, in_10, in_11 : in std_logic_vector(n-1 downto 0);
          sel : in std_logic_vector(1 downto 0);
          data_out : out std_logic_vector(n-1 downto 0));
 end component;

 component mux2to1 is
    generic(n : integer);
    port( in_0, In_1 : in std_logic_vector (n-1 downto 0);
          sel: in std_logic;
          data_out : out std_logic_vector (n-1 downto 0));
 end component;

 component reg is
     generic( n: integer);
     port ( data_in : in std_logic_vector( n-1 downto 0);
            clock, en, reset: in std_logic;                 --reset active high
            data_out : out std_logic_vector( n-1 downto 0));
 end component;

 component flip_flop is
     port ( data_in : in std_logic;
            clock, en, reset: in std_logic; --reset attivo alto
            data_out : out std_logic);
 end component;

 component modular_sub_add is
    port( A,B : in std_logic_vector(255 downto 0);
          clock, reset, start, as_sel : in std_logic;          --reset active high -- if as_sel=1 -> SUB, if as_sel=0 -> ADD
          sum_sub_out : out std_logic_vector(255 downto 0);
          done : out std_logic); 
 end component;

 component modular_sum is
    port( A,B : in std_logic_vector(255 downto 0);
          clock, reset, start : in std_logic;          --reset active high 
          sum_out : out std_logic_vector(255 downto 0);
          done : out std_logic); 
 end component;

 component modular_mult_RADIX4_precomp is
    port( A,B : in std_logic_vector(255 downto 0);
          clock, reset, start, shift : in std_logic;          --reset active high 
          mult_out : out std_logic_vector(255 downto 0);
          done : out std_logic); 
 end component;

component Counter is
    Port ( clock, reset, en : in std_logic;
           count : out std_logic_vector(7 downto 0));
end component;

  begin

---  MULT1 & mux1 & mux2

mux1_in00 <= x1;
mux1_in01 <= mult1_out;
mux1_in10 <= d;
mux1_in11 <= add_1_out;
mux1: mux4to1 generic map (n => 256)
              port map ( mux1_in00, mux1_in01 , mux1_in10, mux1_in11, mux1_sel, mux1_out);

mux2_in00 <= x2;
mux2_in01 <= mult2_out;
mux2_in10 <= mult1_out;
mux2_in11 <= reg3_out;
mux2: mux4to1 generic map (n => 256)
              port map ( mux2_in00, mux2_in01 , mux2_in10, mux2_in11, mux2_sel, mux2_out);

reg3: reg generic map ( n => 256 )
          port map ( mult4_out , clock, reg3_load, reset, reg3_out );

A1 <= mux1_out;
B1 <= mux2_out;
mult1 : modular_mult_RADIX4_precomp port map (A1, B1, clock, reset_m1, start_m1, shift, mult1_out, done_m1);

y3 <= mult1_out;


---  MULT2 & mux3 & mux3

mux3_in00 <= y1;
mux3_in01 <= mult3_out;
mux3_in10 <= add_1_out;
-- mux3_in11 floating
mux3: mux4to1 generic map (n => 256)
              port map ( mux3_in00, mux3_in01 , mux3_in10, mux3_in11, mux3_sel, mux3_out);

mux4_in00 <= y2;
mux4_in01 <= mult3_out;
mux4_in10 <= add_sub_1_out;
--mux4_in11 floating
mux4: mux4to1 generic map (n => 256)
              port map ( mux4_in00, mux4_in01 , mux4_in10, mux4_in11, mux4_sel, mux4_out);

A2 <= mux3_out;
B2 <= mux4_out;
mult2 : modular_mult_RADIX4_precomp port map (A2, B2, clock, reset_m2, start_m2, shift, mult2_out, done_m2);

reg2: reg generic map ( n => 256 )
          port map ( mult2_out , clock, reg2_load, reset, reg2_out );

z3 <= mult2_out;


---  MULT3 & mux5 & mux6

mux5_in0 <= z1;
mux5_in1 <= add_sub_1_out;
mux5: mux2to1 generic map (n => 256)
              port map ( mux5_in0, mux5_in1, mux5_sel, mux5_out);

mux6_in0 <= z2;
mux6_in1 <= mult5_out;
mux6: mux2to1 generic map (n => 256)
              port map ( mux6_in0, mux6_in1, mux6_sel, mux6_out);

A3 <= mux5_out;
B3 <= mux6_out;
mult3 : modular_mult_RADIX4_precomp port map (A3, B3, clock, reset_m3, start_m3, shift, mult3_out, done_m3);

reg1: reg generic map ( n => 256 )
          port map ( mult3_out , clock, reg1_load, reset, reg1_out );

x3 <= mult3_out;


---  MULT4 & mux7 & mux8

mux7_in0 <= x1;
mux7_in1 <= reg1_out;
mux7: mux2to1 generic map (n => 256)
              port map ( mux7_in0, mux7_in1, mux7_sel, mux7_out);

mux8_in0 <= y2;
mux8_in1 <= add_1_out;
mux8: mux2to1 generic map (n => 256)
              port map ( mux8_in0, mux8_in1, mux8_sel, mux8_out);

A4 <= mux7_out;
B4 <= mux8_out;
mult4 : modular_mult_RADIX4_precomp port map (A4, B4, clock, reset_m4, start_m4, shift, mult4_out, done_m4);


---  MULT5 & mux9 & mux10

mux9_in0 <= x2;
mux9_in1 <= reg1_out;
mux9: mux2to1 generic map (n => 256)
              port map ( mux9_in0, mux9_in1, mux9_sel, mux9_out);

mux10_in0 <= y1;
mux10_in1 <=  add_sub_1_out;
mux10: mux2to1 generic map (n => 256)
              port map ( mux10_in0, mux10_in1, mux10_sel, mux10_out);

A5 <= mux9_out;
B5 <= mux10_out;
mult5 : modular_mult_RADIX4_precomp port map (A5, B5, clock, reset_m5, start_m5, shift, mult5_out, done_m5);

---  ADD_1 & mux11 & mux12

mux11_in0 <= mult1_out;
mux11_in1 <= mult1_out;
mux11: mux2to1 generic map (n => 256)
              port map ( mux11_in0, mux11_in1, mux11_sel, mux11_out);

mux12_in0 <= mult2_out;
mux12_in1 <=  reg2_out;
mux12: mux2to1 generic map (n => 256)
              port map ( mux12_in0, mux12_in1, mux12_sel, mux12_out);

A6 <= mux11_out;
B6 <= mux12_out;
add_1 : modular_sum port map (A6, B6, clock, reset_s1, start_s1, add_1_out, done_s1);


---  ADD_SUB_1 & mux13 & mux14

mux13_in0 <= mult4_out;
mux13_in1 <= reg2_out;
mux13: mux2to1 generic map (n => 256)
              port map ( mux13_in0, mux13_in1, mux13_sel, mux13_out);

mux14_in0 <= mult5_out;
mux14_in1 <=  mult1_out;
mux14: mux2to1 generic map (n => 256)
              port map ( mux14_in0, mux14_in1, mux14_sel, mux14_out);

A7 <= mux13_out;
B7 <= mux14_out;
add_sub_1 : modular_sub_add port map (A7, B7, clock, reset_as1, start_as1, as1_sel, add_sub_1_out, done_as1);


--- LEVEL DONE ---

done_L1 <= done_m1 and done_m2 and done_m3 and done_m4 and done_m5;
done_L2 <= done_m1 and done_m2 and ff4_out and ff5_out;

ff4: flip_flop port map ( done_s1 , clock, done_s1, reset, ff4_out );

ff5: flip_flop port map ( done_as1 , clock, done_as1, reset, ff5_out );

done_L3 <= done_m1 and done_m4 and done_m5;
done_L4 <= done_s1 and done_as1;
done_L5 <= done_m1 and done_m2 and done_m3;

cnt : counter port map(clock, cnt_reset, cnt_en, count);

 end architecture;
