library ieee;
use ieee.std_logic_1164.all;
use ieee.numeric_std.all;
use work.curve_parameter_pkg.all;

 entity point_addition_RADIX4 is

    port( x1, x2, y1, y2, z1, z2 : in std_logic_vector(255 downto 0);
          clock, reset, start : in std_logic;          --reset active high 
          done : out std_logic;
          x3,y3,z3 : out std_logic_vector( 255 downto 0));

 end entity;

 architecture behavioural of point_addition_RADIX4 is

signal done_pa, reset_pa : std_logic;
signal mux1_sel, mux2_sel, mux3_sel, mux4_sel : std_logic_vector(1 downto 0);
signal mux5_sel, mux6_sel, mux7_sel, mux8_sel, mux9_sel, mux10_sel, mux11_sel, mux12_sel, mux13_sel, mux14_sel : std_logic;
signal shift, start_m1, start_m2, start_m3, start_m4, start_m5, start_s1, start_as1, as1_sel : std_logic;
signal reset_m1, reset_m2, reset_m3, reset_m4, reset_m5, reset_s1, reset_as1 : std_logic;
signal reg1_load, reg2_load, reg3_load, cnt_reset, cnt_en : std_logic;
signal done_L1, done_L2, done_L3, done_L4, done_L5 : std_logic;
signal count : std_logic_vector(7 downto 0);



 component point_addition_RADIX4_datapath is

    port( x1, x2, y1, y2, z1, z2 : in std_logic_vector(255 downto 0);
          clock, reset, start : in std_logic;          --reset active high 
          x3,y3,z3 : out std_logic_vector( 255 downto 0);
          mux1_sel, mux2_sel, mux3_sel, mux4_sel : in std_logic_vector(1 downto 0);
          mux5_sel, mux6_sel, mux7_sel, mux8_sel, mux9_sel, mux10_sel, mux11_sel, mux12_sel, mux13_sel, mux14_sel : in std_logic;
          shift, start_m1, start_m2, start_m3, start_m4, start_m5, start_s1, start_as1, as1_sel : in std_logic;
          reset_m1, reset_m2, reset_m3, reset_m4, reset_m5, reset_s1, reset_as1 : in std_logic;
          reg1_load, reg2_load, reg3_load, cnt_reset, cnt_en : in std_logic;
          done_L1, done_L2, done_L3, done_L4, done_L5 : out std_logic;
          count : out std_logic_vector(7 downto 0));

 end component;

 component point_addition_RADIX4_fsm is

    port( clock, reset, start : in std_logic;          --reset active high 
          done_pa, reset_pa : out std_logic;
          mux1_sel, mux2_sel, mux3_sel, mux4_sel : out std_logic_vector(1 downto 0);
          mux5_sel, mux6_sel, mux7_sel, mux8_sel, mux9_sel, mux10_sel, mux11_sel, mux12_sel, mux13_sel, mux14_sel : out std_logic;
          shift, start_m1, start_m2, start_m3, start_m4, start_m5, start_s1, start_as1, as1_sel : out std_logic;
          reset_m1, reset_m2, reset_m3, reset_m4, reset_m5, reset_s1, reset_as1 : out std_logic;
          reg1_load, reg2_load, reg3_load, cnt_reset, cnt_en : out std_logic;
          done_L1, done_L2, done_L3, done_L4, done_L5 : in std_logic;
          count : in std_logic_vector(7 downto 0));

 end component;

  begin

datapath : point_addition_RADIX4_datapath port map ( x1, x2, y1, y2, z1, z2, clock, reset_pa, start, x3, y3, z3, mux1_sel, mux2_sel, mux3_sel, mux4_sel, 
          mux5_sel, mux6_sel, mux7_sel, mux8_sel, mux9_sel, mux10_sel, mux11_sel, mux12_sel, mux13_sel, mux14_sel, shift, start_m1, start_m2, start_m3,
          start_m4, start_m5, start_s1, start_as1, as1_sel, reset_m1, reset_m2, reset_m3, reset_m4, reset_m5, reset_s1, reset_as1, reg1_load, reg2_load,
          reg3_load, cnt_reset, cnt_en, done_L1, done_L2, done_L3, done_L4, done_L5, count);

fsm : point_addition_RADIX4_fsm port map (clock, reset, start, done_pa, reset_pa, mux1_sel, mux2_sel, mux3_sel, mux4_sel, mux5_sel, mux6_sel, mux7_sel,
          mux8_sel, mux9_sel, mux10_sel, mux11_sel, mux12_sel, mux13_sel, mux14_sel, shift, start_m1, start_m2, start_m3, start_m4, start_m5, start_s1,
          start_as1, as1_sel, reset_m1, reset_m2, reset_m3, reset_m4, reset_m5, reset_s1, reset_as1, reg1_load, reg2_load, reg3_load, cnt_reset, cnt_en, done_L1, done_L2,
          done_L3, done_L4, done_L5, count);

done <= done_pa;

 end architecture;
