library ieee;
use ieee.std_logic_1164.all;
use ieee.numeric_std.all;

entity point_addition_RADIX2_fsm is

port(     clock, reset, start : in std_logic;          --reset active high 
          done_pa, reset_pa : out std_logic;
          mux1_sel, mux2_sel, mux3_sel, mux4_sel : out std_logic_vector(1 downto 0);
          mux5_sel, mux6_sel, mux7_sel, mux8_sel, mux9_sel, mux10_sel, mux11_sel, mux12_sel, mux13_sel, mux14_sel : out std_logic;
          shift, start_m1, start_m2, start_m3, start_m4, start_m5, start_s1, start_as1, as1_sel : out std_logic;
          reset_m1, reset_m2, reset_m3, reset_m4, reset_m5, reset_s1, reset_as1 : out std_logic;
          reg1_load, reg2_load, reg3_load, cnt_reset, cnt_en : out std_logic;
          done_L1, done_L2, done_L3, done_L4, done_L5 : in std_logic;
          count : in std_logic_vector(7 downto 0));

end entity;

architecture structural of point_addition_RADIX2_fsm is

-------machine state----------
type state_type is (IDLE,L1_A,L1_B,L1_C,L2_B,L2_C,L3_B,L3_C,L4_B,L5_A,L5_B,L5_C,L5_D); --stati
signal present_state, next_state: state_type; --stato corrente, stato futuro

--..............................................SIGNAL.......................................................

--there are no signal because there is only the fsm and there is not the datapath inside this block

--.............................................COMPONENT.....................................................

--there are no component because there is only the fsm and there is not the datapath inside this block

--.................................................FSM........................................................
 begin

------------state update-------------
update_state: process(clock, reset)
begin

 if reset='1' then present_state <= IDLE;  --reset active high
 elsif (clock'event and clock='1') then present_state <= next_state;
 end if;

end process;

---------state transition------------
state_transition: process(clock, present_state)
begin
case present_state is

 when IDLE => if start = '1' then next_state <= L1_A; else next_state <= IDLE; end if;
 when L1_A => next_state <= L1_B;
 when L1_B => if count = "11111111" then next_state <= L1_C; else next_state <= L1_B; end if;
 when L1_C => next_state <= L2_B;
 when L2_B => if count = "11111111" then next_state <= L2_C; else next_state <= L2_B; end if;
 when L2_C => next_state <= L3_B;
 when L3_B => if count = "11111111" then next_state <= L3_C; else next_state <= L3_B; end if;
 when L3_C => next_state <= L4_B;
 when L4_B => if done_L4 = '1' then next_state <= L5_A; else next_state <= L4_B; end if;
 when L5_A => next_state <= L5_B;
 when L5_B => if count = "11111110" then next_state <= L5_C; else next_state <= L5_B; end if;
 when L5_C => next_state <= L5_D;
 when L5_D => if start = '1' then next_state <= L1_B; else next_state <= IDLE; end if;


end case;
end process;

---------------output-------------
output: process(present_state)
begin
 
--default value signal control
done_pa <= '0'; reset_pa <= '0'; mux1_sel <= "00"; mux2_sel <= "00";  mux3_sel <= "00"; mux4_sel  <= "00";
mux5_sel <= '0'; mux6_sel <= '0'; mux7_sel <= '0'; mux8_sel <= '0'; mux9_sel <= '0'; mux10_sel <= '0'; mux11_sel <= '0'; mux12_sel <= '0'; mux13_sel <= '0'; mux14_sel <= '0';
shift <= '0'; start_m1 <= '0'; start_m2 <= '0'; start_m3 <= '0'; start_m4 <= '0'; start_m5 <= '0'; start_s1 <= '0'; start_as1 <= '0'; reg1_load <= '0'; reg2_load <= '0';
reg3_load <= '0'; reset_m1 <= '0'; reset_m2 <= '0'; reset_m3 <= '0'; reset_m4 <= '0'; reset_m5 <= '0'; reset_s1 <= '0'; reset_as1 <= '0'; as1_sel <= '0';  cnt_reset<= '0';
 cnt_en <= '0';

--definition signal transition for each state, only the signal that switch
case present_state is

 when IDLE => reset_pa <= '1' ; reset_m1 <= '1'; reset_m2 <= '1'; reset_m3 <= '1'; reset_m4 <= '1'; reset_m5 <= '1'; reset_s1 <= '1'; reset_as1 <= '1';

 when L1_A => mux1_sel <= "00"; mux2_sel <= "00";  mux3_sel <= "00"; mux4_sel  <= "00"; mux5_sel <= '0'; mux6_sel <= '0'; mux7_sel <= '0'; mux8_sel <= '0';
              mux9_sel <= '0'; mux10_sel <= '0'; mux11_sel <= '0'; mux12_sel <= '0'; mux13_sel <= '0'; mux14_sel <= '0';
              start_m1 <= '1'; start_m2 <= '1'; start_m3 <= '1'; start_m4 <= '1'; start_m5 <= '1'; start_s1 <= '0'; start_as1 <= '0'; cnt_reset <= '1';
 when L1_B => shift <= '1'; cnt_en <= '1';
 
 when L1_C => reg1_load <='1'; mux1_sel <= "01"; mux2_sel <= "01";  mux3_sel <= "01"; mux4_sel  <= "01"; mux5_sel <= '0'; mux6_sel <= '0'; mux7_sel <= '0'; mux8_sel <= '0';
              mux9_sel <= '0'; mux10_sel <= '0'; mux11_sel <= '0'; mux12_sel <= '0'; mux13_sel <= '0'; mux14_sel <= '0';
              start_m1 <= '1'; start_m2 <= '1'; start_m3 <= '0'; start_m4 <= '0'; start_m5 <= '0'; start_s1 <= '1'; start_as1 <= '1'; as1_sel <= '0'; cnt_reset <= '1';
 when L2_B => shift <= '1'; cnt_en <= '1';

 when L2_C => reg2_load <='1'; mux1_sel <= "10"; mux2_sel <= "10";  mux3_sel <= "00"; mux4_sel  <= "00"; mux5_sel <= '0'; mux6_sel <= '0'; mux7_sel <= '1'; mux8_sel <= '1';
              mux9_sel <= '1'; mux10_sel <= '1'; mux11_sel <= '0'; mux12_sel <= '0'; mux13_sel <= '0'; mux14_sel <= '0';
              start_m1 <= '1'; start_m2 <= '0'; start_m3 <= '0'; start_m4 <= '1'; start_m5 <= '1'; start_s1 <= '0'; start_as1 <= '0'; cnt_reset <= '1';
 when L3_B => shift <= '1'; reset_s1 <= '1'; reset_as1 <= '1'; cnt_en <= '1';

 when L3_C => reg3_load <='1'; mux1_sel <= "00"; mux2_sel <= "00";  mux3_sel <= "00"; mux4_sel  <= "00"; mux5_sel <= '0'; mux6_sel <= '0'; mux7_sel <= '0'; mux8_sel <= '0';
              mux9_sel <= '0'; mux10_sel <= '0'; mux11_sel <= '1'; mux12_sel <= '1'; mux13_sel <= '1'; mux14_sel <= '1';
              start_m1 <= '0'; start_m2 <= '0'; start_m3 <= '0'; start_m4 <= '0'; start_m5 <= '0'; start_s1 <= '1'; start_as1 <= '1'; as1_sel <= '1';
 when L4_B => shift <= '0' ;

 when L5_A => reg3_load <='0'; mux1_sel <= "11"; mux2_sel <= "11";  mux3_sel <= "10"; mux4_sel  <= "10"; mux5_sel <= '1'; mux6_sel <= '1'; mux7_sel <= '0'; mux8_sel <= '0';
              mux9_sel <= '0'; mux10_sel <= '0'; mux11_sel <= '0'; mux12_sel <= '0'; mux13_sel <= '0'; mux14_sel <= '0';
              start_m1 <= '1'; start_m2 <= '1'; start_m3 <= '1'; start_m4 <= '0'; start_m5 <= '0'; start_s1 <= '0'; start_as1 <= '0'; as1_sel <= '0'; cnt_reset <= '1';
 when L5_B => shift <= '1' ; cnt_en <= '1';
 when L5_C => shift <= '1' ; done_pa <='1';
 when L5_D => shift <= '1'; reset_s1 <= '1'; reset_as1 <= '1';
              mux1_sel <= "00"; mux2_sel <= "00";  mux3_sel <= "00"; mux4_sel  <= "00"; mux5_sel <= '0'; mux6_sel <= '0'; mux7_sel <= '0'; mux8_sel <= '0';
              mux9_sel <= '0'; mux10_sel <= '0'; mux11_sel <= '0'; mux12_sel <= '0'; mux13_sel <= '0'; mux14_sel <= '0';
              start_m1 <= '1'; start_m2 <= '1'; start_m3 <= '1'; start_m4 <= '1'; start_m5 <= '1'; start_s1 <= '0'; start_as1 <= '0'; cnt_reset <= '1';


end case;
end process;
 
--..............................................DATAPATH.......................................................

--there are no datapath connection because there is only the fsm and there is not the datapath inside this block
      
                  
end architecture;
