library ieee;
use ieee.std_logic_1164.all;
use ieee.numeric_std.all;

 entity mux8to1_modified is

    generic( n : integer :=256);
    port( in_000, in_001, in_010, in_011, in_100, in_101, in_110, in_111 : in std_logic_vector(n-1 downto 0);
          sel : in std_logic_vector(5 downto 0); -- 6 input selector:  S4 - S5 - S6 - S7 -S8 - S8 -S9
          data_out : out std_logic_vector(n-1 downto 0));

 end entity;

 architecture behavioural of mux8to1_modified is

signal sell : std_logic_vector(2 downto 0);
signal sel_0, sel_1, sel_2, sel_3, sel_4, sel_5, sel_6, mux1_out, mux2_out, mux3_out, mux4_out, mux5_out : std_logic_vector(2 downto 0);

 component mux8to1 is
    generic( n : integer);
    port( in_000, in_001, in_010, in_011, in_100, in_101, in_110, in_111 : in std_logic_vector(n-1 downto 0);
          sel : in std_logic_vector(2 downto 0);
          data_out : out std_logic_vector(n-1 downto 0));
 end component;

 component mux2to1 is
    generic(n : integer);
    port( in_0, In_1 : in std_logic_vector (n-1 downto 0);
          sel: in std_logic;
          data_out : out std_logic_vector (n-1 downto 0));
 end component;

begin

--- DECODER ---
--   process(sel,in_000, in_001, in_010, in_011, in_100, in_101, in_110, in_111)
--    begin
--    if sel= "111111" then sel1 <= "000"; end if;
--    if sel= "011111" then sel1 <= "001"; end if;
--    if sel= "001111" then sel1 <= "010"; end if;
--    if sel= "000111" then sel1 <= "011"; end if;
--    if sel= "000011" then sel1 <= "100"; end if;
--    if sel= "000001" then sel1 <= "101"; end if;
--    if sel= "000000" then sel1 <= "110"; end if;
--   end process;

--- DECODER ---
sel_6 <= "110";
sel_5 <= "101";
sel_4 <= "100";
sel_3 <= "011";
sel_2 <= "010";
sel_1 <= "001";
sel_0 <= "000";

mux1: mux2to1 generic map (n => 3)
              port map (sel_5, sel_6, sel(5), mux1_out);

mux2: mux2to1 generic map (n => 3)
              port map (sel_3, sel_4, sel(3), mux2_out);

mux3: mux2to1 generic map (n => 3)
              port map (sel_1, sel_2, sel(1), mux3_out);

mux4: mux2to1 generic map (n => 3)
              port map (mux2_out, mux1_out, sel(4), mux4_out);

mux5: mux2to1 generic map (n => 3)
              port map (sel_0, mux3_out, sel(0), mux5_out);

mux6: mux2to1 generic map (n => 3)
              port map (mux5_out, mux4_out, sel(2), sell);



--- MUX8to1 ---
mux: mux8to1 generic map (n)
             port map (in_000, in_001, in_010, in_011, in_100, in_101, in_110, in_111, sell, data_out);
 end architecture;
