library ieee;
use ieee.std_logic_1164.all;
use ieee.numeric_std.all;
use work.curve_parameter_pkg.all;

 entity modular_sum is

    port( A,B : in std_logic_vector(255 downto 0);
          clock, reset, start : in std_logic;          --reset active high 
          sum_out : out std_logic_vector(255 downto 0);
          done : out std_logic); 

 end entity;

 architecture behavioural of modular_sum is

signal reg1_out, reg2_out, mux1_in0, mux1_in1, mux1_out : std_logic_vector(255 downto 0);
signal s1_a, s1_b, s2_a, s2_b, s1_out, s2_out, inv_in, inv_out : std_logic_vector(256 downto 0);
signal sign, reg4_out, g1_out, p1_out, g2_out, p2_out: std_logic; --g and p are floating beacause are usless in this application

 component mux2to1 is
    generic(n : integer);
    port( in_0, In_1 : in std_logic_vector (n-1 downto 0);
          sel: in std_logic;
          data_out : out std_logic_vector (n-1 downto 0));
 end component;

 component reg is
     generic( n: integer);
     port ( data_in : in std_logic_vector( n-1 downto 0);
            clock, en, reset: in std_logic;                 --reset active high
            data_out : out std_logic_vector( n-1 downto 0));
 end component;

 component flip_flop is
     port ( data_in : in std_logic;
            clock, en, reset: in std_logic; --reset attivo alto
            data_out : out std_logic);
 end component;

component CLA_257bit is  ----- 257 BIT input/output -------
    port( a_in,b_in : in std_logic_vector( 256 downto 0);
          c_in : in std_logic;
          s : out std_logic_vector( 256 downto 0));
end component;

  begin
 
reg1: reg generic map ( n => 256 )
          port map ( A , clock, start, reset, reg1_out );
s1_a <= '0' & reg1_out;

reg2: reg generic map ( n => 256 )
          port map ( B , clock, start, reset, reg2_out );
s1_b <= '0' & reg2_out;

inv_in <= '0' & p;
inv_out <= not( inv_in);

s1: CLA_257bit port map (s1_a, s1_b, '0', s1_out);
s2: CLA_257bit port map (s1_out, inv_out, '1', s2_out);

mux1_in0 <= s2_out(255 downto 0);
mux1_in1 <= s1_out(255 downto 0);

sign <= s2_out(256); 

mux1: mux2to1 generic map (n => 256)
              port map (mux1_in0, mux1_in1, sign, mux1_out);

reg3: reg generic map ( n => 256 )
          port map ( mux1_out , clock, reg4_out, reset, sum_out ); 
reg4: flip_flop port map ( start , clock, '1', reset, reg4_out );

done <= reg4_out;

 end architecture;

