library ieee;
use ieee.std_logic_1164.all;
use ieee.numeric_std.all;
use work.curve_parameter_pkg.all;

 entity modular_sub_add is

    port( A,B : in std_logic_vector(255 downto 0);
          clock, reset, start, as_sel : in std_logic;          --reset active high -- if as_sel=1 -> SUB, if as_sel=0 -> ADD
          sum_sub_out : out std_logic_vector(255 downto 0);
          done : out std_logic); 

 end entity;

 architecture behavioural of modular_sub_add is

signal reg1_out, reg2_out : std_logic_vector(255 downto 0);
signal s1_a, s1_b, s2_a, s2_b, mux1_in0, mux1_in1, mux1_out, mux2_out, s1_out, s2_out, inv_in, inv_out : std_logic_vector(256 downto 0);
signal mux3_in1, mux3_in0, mux4_in1, mux4_in0, mux3_out, mux4_out, mux5_out  : std_logic_vector(255 downto 0);
signal as, as_not, sign_1, sign_2, reg5_out,  g1_out, p1_out, g2_out, p2_out: std_logic; -- p and g are usless in this application

 component mux2to1 is
    generic(n : integer);
    port( in_0, In_1 : in std_logic_vector (n-1 downto 0);
          sel: in std_logic;
          data_out : out std_logic_vector (n-1 downto 0));
 end component;

 component reg is
     generic( n: integer);
     port ( data_in : in std_logic_vector( n-1 downto 0);
            clock, en, reset: in std_logic;                 --reset active high
            data_out : out std_logic_vector( n-1 downto 0));
 end component;

 component flip_flop is
     port ( data_in : in std_logic;
            clock, en, reset: in std_logic; --reset attivo alto
            data_out : out std_logic);
 end component;

component CLA_257bit is  ----- 257 BIT input/output -------
    port( a_in,b_in : in std_logic_vector( 256 downto 0);
          c_in : in std_logic;
          s : out std_logic_vector( 256 downto 0));
end component;
  begin
 
reg1: reg generic map ( n => 256 )
          port map ( A , clock, start, reset, reg1_out );
s1_a <= '0' & reg1_out;

reg2: reg generic map ( n => 256 )
          port map ( B , clock, start, reset, reg2_out );

reg3: flip_flop port map ( as_sel, clock, start, reset, as );

mux1_in0 <= '0' & reg2_out;
mux1_in1 <= not(mux1_in0);
mux1: mux2to1 generic map (n => 257)
              port map (mux1_in0, mux1_in1, as, mux1_out);

s1_b <= mux1_out;

inv_in <= '0' & p;
inv_out <= not( inv_in);

as_not <= not(as);

mux2: mux2to1 generic map (n => 257)
              port map (inv_in, inv_out, as_not, mux2_out);


s1: CLA_257bit port map (s1_a, s1_b, as, s1_out);
s2: CLA_257bit port map (s1_out, mux2_out, as_not, s2_out);

mux3_in1 <= s2_out(255 downto 0);
mux3_in0 <= s1_out(255 downto 0);

mux4_in1 <= s1_out(255 downto 0);
mux4_in0 <= s2_out(255 downto 0);

sign_1 <= s1_out(256);
sign_2 <= s2_out(256); 

mux3: mux2to1 generic map (n => 256)
              port map (mux3_in0, mux3_in1, sign_1, mux3_out);

mux4: mux2to1 generic map (n => 256)
              port map (mux4_in0, mux4_in1, sign_2, mux4_out);

mux5: mux2to1 generic map (n => 256)
              port map (mux4_out, mux3_out, as, mux5_out);

reg4: reg generic map ( n => 256 )
          port map ( mux5_out , clock, reg5_out, reset, sum_sub_out ); 
reg5: flip_flop port map ( start , clock, '1', reset, reg5_out );

done <= reg5_out;

 end architecture;
