library ieee;
use ieee.std_logic_1164.all;
use ieee.numeric_std.all;

 entity modular_mult_RADIX4_precomp is

    port( A,B : in std_logic_vector(255 downto 0);
          clock, reset, start, shift : in std_logic;          --reset active high 
          mult_out : out std_logic_vector(255 downto 0);
          done : out std_logic); 

 end entity;

 architecture behavioural of modular_mult_RADIX4_precomp is

signal reg1_out : std_logic_vector(255  downto 0);
signal A_in, Ax2, Ax3 : std_logic_vector(257 downto 0); 
signal start1 : std_logic;

 component modular_mult_RADIX4 is

    port( B : in std_logic_vector(255 downto 0);
          A, Ax2, Ax3 : in std_logic_vector(257 downto 0);   --precomputated input given by precomputation block
          clock, reset, start, shift : in std_logic;          --reset active high 
          mult_out : out std_logic_vector(255 downto 0);
          done : out std_logic); 

 end component;

 component precomputation_RADIX4 is

    port( A : in std_logic_vector(255 downto 0);
          clock, reset, start : in std_logic;          --reset active high 
          A_out, Ax2, Ax3 : out std_logic_vector(257 downto 0)); 

 end component;

 component reg is
     generic( n: integer);
     port ( data_in : in std_logic_vector( n-1 downto 0);
            clock, en, reset: in std_logic; --reset attivo alto
            data_out : out std_logic_vector( n-1 downto 0));
 end component;

 component flip_flop is
     port ( data_in : in std_logic;
            clock, en, reset: in std_logic; --reset attivo alto
            data_out : out std_logic);
 end component;

begin

reg1: reg generic map ( n => 256 )
          port map ( B , clock, start, reset, reg1_out );

ff : flip_flop port map (start, clock, '1', reset, start1);

precomp : precomputation_RADIX4 port map (A, clock, reset, start, A_in, Ax2, Ax3);


mult : modular_mult_RADIX4 port map (reg1_out, A_in, Ax2, Ax3, clock, reset, start1, shift, mult_out, done); 


 end architecture;
