
-- --%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% VERSION 1 %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
--library ieee;
--use ieee.std_logic_1164.all;
--use ieee.numeric_std.all;
--use work.curve_parameter_pkg.all;
--

-- --IMPLEMENTATION WITH SIGN CONTROL 
--
-- entity modular_mult_RADIX4 is
--
--    port( B : in std_logic_vector(255 downto 0);
--          A, Ax2, Ax3 : in std_logic_vector(257 downto 0);   --precomputated input given by precomputation block
--          clock, reset, start, shift : in std_logic;          --reset active high 
--          mult_out : out std_logic_vector(255 downto 0);
--          done : out std_logic); 
--
-- end entity;
--
-- architecture behavioural of modular_mult_RADIX4 is
--
--signal or_in, reg4_in : std_logic_vector(255 downto 0);
--
--signal reg1_out, reg2_out, reg3_out, s1_a, s1_b, s2_a, s3_a, mux1_out, s1_out, s2_out, s3_out : std_logic_vector(257 downto 0);
--signal s4_a, s5_a, s6_a, s7_a, s8_a, s9_a, s_b, mux2_out, s4_out, s5_out, s6_out, s7_out, s8_out, s9_out, inv1_in : std_logic_vector(258 downto 0);
--signal reg11_out, reg10_out, reg9_out, reg7_out, reg6_out, reg5_out, reg8_out, mux2_bis_out : std_logic_vector(258 downto 0);
--
--signal reg_shift_out, reg_fourt_in, reg_fourt_out : std_logic_vector(257 downto 0);
--signal mux1_sel : std_logic_vector(1 downto 0);
--signal or_out, s4_sign, s5_sign,  s6_sign,  s7_sign,  s8_sign,  s9_sign: std_logic;
--signal mux2_sel : std_logic_vector(2 downto 0);
--signal mux2_bis_sel : std_logic_vector(5 downto 0);
--
-- component mux4to1 is
--    generic( n : integer);
--    port( in_00, in_01, in_10, in_11 : in std_logic_vector(n-1 downto 0);
--          sel : in std_logic_vector(1 downto 0);
--          data_out : out std_logic_vector(n-1 downto 0));
-- end component;
--
-- component mux8to1_modified is
--    generic( n : integer);
--    port( in_000, in_001, in_010, in_011, in_100, in_101, in_110, in_111 : in std_logic_vector(n-1 downto 0);
--          sel : in std_logic_vector(5 downto 0); -- 6 input selector
--          data_out : out std_logic_vector(n-1 downto 0));
-- end component;
--
-- component reg is
--     generic( n: integer);
--     port ( data_in : in std_logic_vector( n-1 downto 0);
--            clock, en, reset: in std_logic;                 --reset active high
--            data_out : out std_logic_vector( n-1 downto 0));
-- end component;
--
--component OR_256bit is
--    Port ( input_bits : in STD_LOGIC_VECTOR(255 downto 0);
--           or_output : out STD_LOGIC);
--end component;
--
--component CLA_258bit is  --------- 259 BIT input/output ---------
--    port( a_in,b_in : in std_logic_vector( 257 downto 0);
--          c_in : in std_logic;
--          s : out std_logic_vector( 257 downto 0));
--end component;
--
--component CLA_259bit is  --------- 259 BIT input/output ---------
--    port( a_in,b_in : in std_logic_vector( 258 downto 0);
--          c_in : in std_logic;
--          s : out std_logic_vector( 258 downto 0));
--end component;
--
-- component shift_reg2 is
--     generic( n: integer);
--     port ( data_in : in std_logic_vector( n-1 downto 0);
--            clock, en, reset, shift: in std_logic; --reset active high, en enable the loading, shift enable the shift
--            data_out : out std_logic_vector(n+1 downto 0));
-- end component;
--
-- component mux8to1 is
--    generic( n : integer);
--    port( in_000, in_001, in_010, in_011, in_100, in_101, in_110, in_111 : in std_logic_vector(n-1 downto 0);
--          sel : in std_logic_vector(2 downto 0);
--          data_out : out std_logic_vector(n-1 downto 0));
-- end component;
--
--
--  begin
-- 
--reg1: reg generic map ( n => 258 )
--          port map ( A , clock, start, reset, reg1_out );
--
--reg2: reg generic map ( n => 258 )
--          port map ( Ax2 , clock, start, reset, reg2_out );
--
--reg3: reg generic map ( n => 258 )
--          port map ( Ax3 , clock, start, reset, reg3_out );
--
--s1_a <= reg1_out;
--s2_a <= reg2_out;
--s3_a <= reg3_out;
--
--shift_reg: shift_reg2 generic map ( n => 256 )
--          port map ( B , clock, start, reset, shift, reg_shift_out );
--
--mux1_sel <= reg_shift_out(257 downto 256);
--
--or_in <= reg_shift_out(255 downto 0);
--or_gate : OR_256bit port map (or_in, or_out);
--
--reg_fourt_in <= mux2_out (257 downto 0);
--reg_fourt: reg generic map ( n => 258 )
--          port map ( reg_fourt_in , clock, '1', start, reg_fourt_out ); --reset is connected to the start, each time the mult is started the register is resetted
--s1_b <= reg_fourt_out(255 downto 0) & "00"; -- x4
--
--s1: CLA_258bit port map (s1_a, s1_b, '0', s1_out);
--s2: CLA_258bit port map (s2_a, s1_b, '0', s2_out);
--s3: CLA_258bit port map (s3_a, s1_b, '0', s3_out);
--
--mux1: mux4to1 generic map (n => 258)
--              port map (s1_b, s1_out, s2_out, s3_out, mux1_sel, mux1_out);
--
--inv1_in <= '0' & '0' & '0' & p;
--s4_a <= not( inv1_in);
--s5_a <= not(px2);
--s6_a <= not(px3);
--s7_a <= not(px4);
--s8_a <= not(px5);
--s9_a <= not(px6);
--
--s_b <= '0' & mux1_out;
--
--s4: CLA_259bit port map (s4_a, s_b, '1', s4_out);
--s5: CLA_259bit port map (s5_a, s_b, '1', s5_out);
--s6: CLA_259bit port map (s6_a, s_b, '1', s6_out);
--s7: CLA_259bit port map (s7_a, s_b, '1', s7_out);
--s8: CLA_259bit port map (s8_a, s_b, '1', s8_out);
--s9: CLA_259bit port map (s9_a, s_b, '1', s9_out);
--
------ MUX 2 ----
--
--mux2_sel <= mux1_out(257 downto 255);
--
--mux2: mux8to1 generic map (n => 259)
--             port map (s_b, s4_out, s5_out, s6_out, s7_out, s8_out, s9_out, s9_out, mux2_sel, mux2_out);
--
------ MUX 2 BIS ----
--
--reg5: reg generic map ( n => 259 )
--          port map ( s4_out , clock, or_out, reset, reg5_out ); 
--
--reg6: reg generic map ( n => 259 )
--          port map ( s5_out , clock, or_out, reset, reg6_out ); 
--
--reg7: reg generic map ( n => 259 )
--          port map ( s6_out , clock, or_out, reset, reg7_out ); 
--
--reg8: reg generic map ( n => 259 )
--          port map ( s_b , clock, or_out, reset, reg8_out ); 
--
--reg9: reg generic map ( n => 259 )
--          port map ( s7_out , clock, or_out, reset, reg9_out ); 
--
--reg10: reg generic map ( n => 259 )
--          port map ( s8_out , clock, or_out, reset, reg10_out ); 
--
--reg11: reg generic map ( n => 259 )
--          port map ( s9_out , clock, or_out, reset, reg11_out ); 
--
--s4_sign <= reg5_out(258);
--s5_sign <= reg6_out(258);
--s6_sign <= reg7_out(258);
--s7_sign <= reg9_out(258);
--s8_sign <= reg10_out(258);
--s9_sign <= reg11_out(258);
--
--mux2_bis_sel <= s4_sign & s5_sign & s6_sign & s7_sign & s8_sign & s9_sign ;
--
--mux2_bis: mux8to1_modified generic map (n => 259)
--              port map (reg11_out, reg10_out, reg9_out, reg7_out, reg6_out, reg5_out, reg8_out, reg8_out, mux2_bis_sel, mux2_bis_out);
--
--mult_out <= mux2_bis_out(255 downto 0);
--
--done <= not(or_out);
--
-- end architecture;







---- %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% VERSION 2 %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
--library ieee;
--use ieee.std_logic_1164.all;
--use ieee.numeric_std.all;
--use work.curve_parameter_pkg.all;
--

---- IMPLEMENTATION WITHOUT SIGN CONTROL
--
-- entity modular_mult_RADIX4 is
--
--    port( B : in std_logic_vector(255 downto 0);
--          A, Ax2, Ax3 : in std_logic_vector(257 downto 0);   --precomputated input given by precomputation block
--          clock, reset, start, shift : in std_logic;          --reset active high 
--          mult_out : out std_logic_vector(255 downto 0);
--          done : out std_logic); 
--
-- end entity;
--
-- architecture behavioural of modular_mult_RADIX4 is
--
--signal or_in, reg4_in : std_logic_vector(255 downto 0);
--
--signal reg1_out, reg2_out, reg3_out, s1_a, s1_b, s2_a, s3_a, mux1_out, s1_out, s2_out, s3_out : std_logic_vector(257 downto 0);
--signal s4_a, s5_a, s6_a, s7_a, s8_a, s9_a, s_b, mux2_out, s4_out, s5_out, s6_out, s7_out, s8_out, s9_out, inv1_in : std_logic_vector(257 downto 0);
--signal reg11_out, reg10_out, reg9_out, reg7_out, reg6_out, reg5_out, reg8_out, mux2_bis_out : std_logic_vector(257 downto 0);
--
--signal reg_shift_out, reg_fourt_in, reg_fourt_out : std_logic_vector(257 downto 0);
--signal mux1_sel : std_logic_vector(1 downto 0);
--signal or_out, s4_sign, s5_sign,  s6_sign,  s7_sign,  s8_sign,  s9_sign: std_logic;
--signal mux2_sel : std_logic_vector(2 downto 0);
--signal mux2_bis_sel : std_logic_vector(5 downto 0);
--
-- component mux4to1 is
--    generic( n : integer);
--    port( in_00, in_01, in_10, in_11 : in std_logic_vector(n-1 downto 0);
--          sel : in std_logic_vector(1 downto 0);
--          data_out : out std_logic_vector(n-1 downto 0));
-- end component;
--
-- component mux8to1_modified is
--    generic( n : integer);
--    port( in_000, in_001, in_010, in_011, in_100, in_101, in_110, in_111 : in std_logic_vector(n-1 downto 0);
--          sel : in std_logic_vector(5 downto 0); -- 6 input selector
--          data_out : out std_logic_vector(n-1 downto 0));
-- end component;
--
-- component reg is
--     generic( n: integer);
--     port ( data_in : in std_logic_vector( n-1 downto 0);
--            clock, en, reset: in std_logic;                 --reset active high
--            data_out : out std_logic_vector( n-1 downto 0));
-- end component;
--
--component OR_256bit is
--    Port ( input_bits : in STD_LOGIC_VECTOR(255 downto 0);
--           or_output : out STD_LOGIC);
--end component;
--
--component CLA_258bit is  --------- 259 BIT input/output ---------
--    port( a_in,b_in : in std_logic_vector( 257 downto 0);
--          c_in : in std_logic;
--          s : out std_logic_vector( 257 downto 0));
--end component;
--
--component CLA_259bit is  --------- 259 BIT input/output ---------
--    port( a_in,b_in : in std_logic_vector( 258 downto 0);
--          c_in : in std_logic;
--          s : out std_logic_vector( 258 downto 0));
--end component;
--
-- component shift_reg2 is
--     generic( n: integer);
--     port ( data_in : in std_logic_vector( n-1 downto 0);
--            clock, en, reset, shift: in std_logic; --reset active high, en enable the loading, shift enable the shift
--            data_out : out std_logic_vector(n+1 downto 0));
-- end component;
--
-- component mux8to1 is
--    generic( n : integer);
--    port( in_000, in_001, in_010, in_011, in_100, in_101, in_110, in_111 : in std_logic_vector(n-1 downto 0);
--          sel : in std_logic_vector(2 downto 0);
--          data_out : out std_logic_vector(n-1 downto 0));
-- end component;
--
--
--  begin
-- 
--reg1: reg generic map ( n => 258 )
--          port map ( A , clock, start, reset, reg1_out );
--
--reg2: reg generic map ( n => 258 )
--          port map ( Ax2 , clock, start, reset, reg2_out );
--
--reg3: reg generic map ( n => 258 )
--          port map ( Ax3 , clock, start, reset, reg3_out );
--
--s1_a <= reg1_out;
--s2_a <= reg2_out;
--s3_a <= reg3_out;
--
--shift_reg: shift_reg2 generic map ( n => 256 )
--          port map ( B , clock, start, reset, shift, reg_shift_out );
--
--mux1_sel <= reg_shift_out(257 downto 256);
--
--or_in <= reg_shift_out(255 downto 0);
--or_gate : OR_256bit port map (or_in, or_out);
--
--reg_fourt_in <= mux2_out (257 downto 0);
--reg_fourt: reg generic map ( n => 258 )
--          port map ( reg_fourt_in , clock, '1', start, reg_fourt_out ); --reset is connected to the start, each time the mult is started the register is resetted
--s1_b <= reg_fourt_out(255 downto 0) & "00"; -- x4
--
--s1: CLA_258bit port map (s1_a, s1_b, '0', s1_out);
--s2: CLA_258bit port map (s2_a, s1_b, '0', s2_out);
--s3: CLA_258bit port map (s3_a, s1_b, '0', s3_out);
--
--mux1: mux4to1 generic map (n => 258)
--              port map (s1_b, s1_out, s2_out, s3_out, mux1_sel, mux1_out);
--
--inv1_in <= '0' & '0' & p;
--s4_a <= not( inv1_in);
--s5_a <= not(px2);
--s6_a <= not(px3);
--s7_a <= not(px4);
--s8_a <= not(px5);
--s9_a <= not(px6);
--
--s_b <= mux1_out;
--
--s4: CLA_258bit port map (s4_a, s_b, '1', s4_out);
--s5: CLA_258bit port map (s5_a, s_b, '1', s5_out);
--s6: CLA_258bit port map (s6_a, s_b, '1', s6_out);
--s7: CLA_258bit port map (s7_a, s_b, '1', s7_out);
--s8: CLA_258bit port map (s8_a, s_b, '1', s8_out);
--s9: CLA_258bit port map (s9_a, s_b, '1', s9_out);
--
------ MUX 2 ----
--
--mux2_sel <= mux1_out(257 downto 255);
--
--mux2: mux8to1 generic map (n => 258)
--             port map (s_b, s4_out, s5_out, s6_out, s7_out, s8_out, s9_out, s9_out, mux2_sel, mux2_out);
--
--mult_out <= reg5_out(255 downto 0);
--
--reg4: reg generic map ( n => 258 )
--          port map ( mux2_out , clock, or_out, reset, reg5_out );
--
--done <= not(or_out);
--
-- end architecture;





-- --%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% VERSION 3 %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
--library ieee;
--use ieee.std_logic_1164.all;
--use ieee.numeric_std.all;
--use work.curve_parameter_pkg.all;
--
--
---- IMPLEMENTATION WITH OUTPUT DINAMIC CONTROL
--
-- entity modular_mult_RADIX4 is
--
--    port( B : in std_logic_vector(255 downto 0);
--          A, Ax2, Ax3 : in std_logic_vector(257 downto 0);   --precomputated input given by precomputation block
--          clock, reset, start, shift : in std_logic;          --reset active high 
--          mult_out : out std_logic_vector(255 downto 0);
--          done : out std_logic); 
--
-- end entity;
--
-- architecture behavioural of modular_mult_RADIX4 is
--
--signal or_in, reg4_in, mux3_in0, mux3_in1, mux3_out : std_logic_vector(255 downto 0);
--
--signal reg1_out, reg2_out, reg3_out, s1_a, s1_b, s2_a, s3_a, mux1_out, s1_out, s2_out, s3_out : std_logic_vector(257 downto 0);
--signal s4_a, s5_a, s6_a, s7_a, s8_a, s9_a, s_b, mux2_out, s4_out, s5_out, s6_out, s7_out, s8_out, s9_out, inv1_in : std_logic_vector(257 downto 0);
--signal reg11_out, reg10_out, reg9_out, reg7_out, reg6_out, reg5_out, reg8_out, mux2_bis_out : std_logic_vector(257 downto 0);
--signal s10_a, s10_b, s10_out : std_logic_vector(256 downto 0);
--
--signal reg_shift_out, reg_fourt_in, reg_fourt_out : std_logic_vector(257 downto 0);
--signal mux1_sel : std_logic_vector(1 downto 0);
--signal or_out, s4_sign, s5_sign,  s6_sign,  s7_sign,  s8_sign,  s9_sign, mux3_sel: std_logic;
--signal mux2_sel : std_logic_vector(2 downto 0);
--signal mux2_bis_sel : std_logic_vector(5 downto 0);
--
-- component mux4to1 is
--    generic( n : integer);
--    port( in_00, in_01, in_10, in_11 : in std_logic_vector(n-1 downto 0);
--          sel : in std_logic_vector(1 downto 0);
--          data_out : out std_logic_vector(n-1 downto 0));
-- end component;
--
-- component mux8to1_modified is
--    generic( n : integer);
--    port( in_000, in_001, in_010, in_011, in_100, in_101, in_110, in_111 : in std_logic_vector(n-1 downto 0);
--          sel : in std_logic_vector(5 downto 0); -- 6 input selector
--          data_out : out std_logic_vector(n-1 downto 0));
-- end component;
--
-- component reg is
--     generic( n: integer);
--     port ( data_in : in std_logic_vector( n-1 downto 0);
--            clock, en, reset: in std_logic;                 --reset active high
--            data_out : out std_logic_vector( n-1 downto 0));
-- end component;
--
--component OR_256bit is
--    Port ( input_bits : in STD_LOGIC_VECTOR(255 downto 0);
--           or_output : out STD_LOGIC);
--end component;
--
--component CLA_258bit is  --------- 259 BIT input/output ---------
--    port( a_in,b_in : in std_logic_vector( 257 downto 0);
--          c_in : in std_logic;
--          s : out std_logic_vector( 257 downto 0));
--end component;
--
--component CLA_259bit is  --------- 259 BIT input/output ---------
--    port( a_in,b_in : in std_logic_vector( 258 downto 0);
--          c_in : in std_logic;
--          s : out std_logic_vector( 258 downto 0));
--end component;
--
-- component shift_reg2 is
--     generic( n: integer);
--     port ( data_in : in std_logic_vector( n-1 downto 0);
--            clock, en, reset, shift: in std_logic; --reset active high, en enable the loading, shift enable the shift
--            data_out : out std_logic_vector(n+1 downto 0));
-- end component;
--
-- component mux8to1 is
--    generic( n : integer);
--    port( in_000, in_001, in_010, in_011, in_100, in_101, in_110, in_111 : in std_logic_vector(n-1 downto 0);
--          sel : in std_logic_vector(2 downto 0);
--          data_out : out std_logic_vector(n-1 downto 0));
-- end component;
--
--component CLA_257bit is --------- 257 BIT input/output ---------
--    port( a_in,b_in : in std_logic_vector( 256 downto 0);
--          c_in : in std_logic;
--          s : out std_logic_vector( 256 downto 0));
--end component;
--
-- component mux2to1 is
--    generic(n : integer);
--    port( in_0, In_1 : in std_logic_vector (n-1 downto 0);
--          sel: in std_logic;
--          data_out : out std_logic_vector (n-1 downto 0));
-- end component;
--
--
--  begin
-- 
--reg1: reg generic map ( n => 258 )
--          port map ( A , clock, start, reset, reg1_out );
--
--reg2: reg generic map ( n => 258 )
--          port map ( Ax2 , clock, start, reset, reg2_out );
--
--reg3: reg generic map ( n => 258 )
--          port map ( Ax3 , clock, start, reset, reg3_out );
--
--s1_a <= reg1_out;
--s2_a <= reg2_out;
--s3_a <= reg3_out;
--
--shift_reg: shift_reg2 generic map ( n => 256 )
--          port map ( B , clock, start, reset, shift, reg_shift_out );
--
--mux1_sel <= reg_shift_out(257 downto 256);
--
--or_in <= reg_shift_out(255 downto 0);
--or_gate : OR_256bit port map (or_in, or_out);
--
--reg_fourt_in <= mux2_out (257 downto 0);
--reg_fourt: reg generic map ( n => 258 )
--          port map ( reg_fourt_in , clock, '1', start, reg_fourt_out ); --reset is connected to the start, each time the mult is started the register is resetted
--s1_b <= reg_fourt_out(255 downto 0) & "00"; -- x4
--
--s1: CLA_258bit port map (s1_a, s1_b, '0', s1_out);
--s2: CLA_258bit port map (s2_a, s1_b, '0', s2_out);
--s3: CLA_258bit port map (s3_a, s1_b, '0', s3_out);
--
--mux1: mux4to1 generic map (n => 258)
--              port map (s1_b, s1_out, s2_out, s3_out, mux1_sel, mux1_out);
--
--inv1_in <= '0' & '0' & p;
--s4_a <= not( inv1_in);
--s5_a <= not(px2);
--s6_a <= not(px3);
--s7_a <= not(px4);
--s8_a <= not(px5);
--s9_a <= not(px6);
--
--s_b <= mux1_out;
--
--s4: CLA_258bit port map (s4_a, s_b, '1', s4_out);
--s5: CLA_258bit port map (s5_a, s_b, '1', s5_out);
--s6: CLA_258bit port map (s6_a, s_b, '1', s6_out);
--s7: CLA_258bit port map (s7_a, s_b, '1', s7_out);
--s8: CLA_258bit port map (s8_a, s_b, '1', s8_out);
--s9: CLA_258bit port map (s9_a, s_b, '1', s9_out);
--
------ MUX 2 ----
--
--mux2_sel <= mux1_out(257 downto 255);
--
--mux2: mux8to1 generic map (n => 258)
--             port map (s_b, s4_out, s5_out, s6_out, s7_out, s8_out, s9_out, s9_out, mux2_sel, mux2_out);
--
--
--reg5: reg generic map ( n => 258 )
--          port map ( mux2_out , clock, or_out, reset, reg5_out );
--
--done <= not(or_out);
--
----- OUTPUT DINAMIC CONTROL ---
--
--s10_a <= reg5_out(256 downto 0);
--s10_b <= not('0' & p);
--
--s10: CLA_257bit port map (s10_a, s10_b, '1', s10_out);
--
--mux3_in0 <= s10_out(255 downto 0);
--mux3_in1 <= reg5_out(255 downto 0);
--mux3_sel <= s10_out(256);
--
--mux3: mux2to1 generic map (n => 256)
--              port map (mux3_in0, mux3_in1, mux3_sel, mux3_out);
--
--mult_out <= mux3_out;
-- end architecture;


 --%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% VERSION 4 %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
library ieee;
use ieee.std_logic_1164.all;
use ieee.numeric_std.all;
use work.curve_parameter_pkg.all;


-- IMPLEMENTATION with only one adder for second part of the algortithm

 entity modular_mult_RADIX4 is

    port( B : in std_logic_vector(255 downto 0);
          A, Ax2, Ax3 : in std_logic_vector(257 downto 0);   --precomputated input given by precomputation block
          clock, reset, start, shift : in std_logic;          --reset active high 
          mult_out : out std_logic_vector(255 downto 0);
          done : out std_logic); 

 end entity;

 architecture behavioural of modular_mult_RADIX4 is

signal or_in, reg4_in, mux3_in0, mux3_in1, mux3_out : std_logic_vector(255 downto 0);

signal reg1_out, reg2_out, reg3_out, s1_a, s1_b, s2_a, s3_a, mux1_out, s1_out, s2_out, s3_out : std_logic_vector(257 downto 0);
signal s4_a, s5_a, s6_a, s7_a, s8_a, s9_a, s_b, mux2_out, s4_out, s5_out, s6_out, s7_out, s8_out, s9_out, inv1_in, mux5_out, mux4_out, reg5_out, pad : std_logic_vector(257 downto 0);
signal s10_a, s10_b, s10_out : std_logic_vector(256 downto 0);

signal reg_shift_out, reg_fourt_in, reg_fourt_out : std_logic_vector(257 downto 0);
signal mux1_sel, mux5_sel : std_logic_vector(1 downto 0);
signal mux2_sel : std_logic_vector(2 downto 0);
signal or_out, s4_sign, s5_sign,  s6_sign,  s7_sign,  s8_sign,  s9_sign, mux3_sel, mux4_sel: std_logic;

 component mux4to1 is
    generic( n : integer);
    port( in_00, in_01, in_10, in_11 : in std_logic_vector(n-1 downto 0);
          sel : in std_logic_vector(1 downto 0);
          data_out : out std_logic_vector(n-1 downto 0));
 end component;

 component reg is
     generic( n: integer);
     port ( data_in : in std_logic_vector( n-1 downto 0);
            clock, en, reset: in std_logic;                 --reset active high
            data_out : out std_logic_vector( n-1 downto 0));
 end component;

component OR_256bit is
    Port ( input_bits : in STD_LOGIC_VECTOR(255 downto 0);
           or_output : out STD_LOGIC);
end component;

component CLA_258bit is  --------- 259 BIT input/output ---------
    port( a_in,b_in : in std_logic_vector( 257 downto 0);
          c_in : in std_logic;
          s : out std_logic_vector( 257 downto 0));
end component;

 component shift_reg2 is
     generic( n: integer);
     port ( data_in : in std_logic_vector( n-1 downto 0);
            clock, en, reset, shift: in std_logic; --reset active high, en enable the loading, shift enable the shift
            data_out : out std_logic_vector(n+1 downto 0));
 end component;

 component mux2to1 is
    generic(n : integer);
    port( in_0, In_1 : in std_logic_vector (n-1 downto 0);
          sel: in std_logic;
          data_out : out std_logic_vector (n-1 downto 0));
 end component;

component CLA_257bit is --------- 257 BIT input/output ---------
    port( a_in,b_in : in std_logic_vector( 256 downto 0);
          c_in : in std_logic;
          s : out std_logic_vector( 256 downto 0));
end component;

 component mux8to1 is
    generic( n : integer);
    port( in_000, in_001, in_010, in_011, in_100, in_101, in_110, in_111 : in std_logic_vector(n-1 downto 0);
          sel : in std_logic_vector(2 downto 0);
          data_out : out std_logic_vector(n-1 downto 0));
 end component;


  begin
 
reg1: reg generic map ( n => 258 )
          port map ( A , clock, start, reset, reg1_out );

reg2: reg generic map ( n => 258 )
          port map ( Ax2 , clock, start, reset, reg2_out );

reg3: reg generic map ( n => 258 )
          port map ( Ax3 , clock, start, reset, reg3_out );

s1_a <= reg1_out;
s2_a <= reg2_out;
s3_a <= reg3_out;

shift_reg: shift_reg2 generic map ( n => 256 )
          port map ( B , clock, start, reset, shift, reg_shift_out );

mux1_sel <= reg_shift_out(257 downto 256);

or_in <= reg_shift_out(255 downto 0);
or_gate : OR_256bit port map (or_in, or_out);

reg_fourt_in <= s4_out (257 downto 0);
reg_fourt: reg generic map ( n => 258 )
          port map ( reg_fourt_in , clock, '1', start, reg_fourt_out ); --reset is connected to the start, each time the mult is started the register is resetted
s1_b <= reg_fourt_out(255 downto 0) & "00"; -- x4

s1: CLA_258bit port map (s1_a, s1_b, '0', s1_out);
s2: CLA_258bit port map (s2_a, s1_b, '0', s2_out);
s3: CLA_258bit port map (s3_a, s1_b, '0', s3_out);

mux1: mux4to1 generic map (n => 258)
              port map (s1_b, s1_out, s2_out, s3_out, mux1_sel, mux1_out);

inv1_in <= '0' & '0' & p;
s4_a <= not( inv1_in);
s5_a <= not(px2);
s6_a <= not(px3);
s7_a <= not(px4);
s8_a <= not(px5);
s9_a <= not(px6);
pad <= not "000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000";

--mux2_sel <= mux1_out(256 downto 255); --msb & msb-1
--mux2: mux4to1 generic map (n => 258)
--              port map (pad, s4_a, s5_a, s6_a, mux2_sel, mux2_out);
--
--mux5: mux4to1 generic map (n => 258)
--              port map (s7_a, s8_a, s9_a, s9_a, mux2_sel, mux5_out);
--
--mux4_sel <= mux1_out(257);
--mux4: mux2to1 generic map (n => 258)
--              port map (mux2_out, mux5_out, mux4_sel, mux4_out);

mux2_sel <= mux1_out(257 downto 255); -- msb, msb-1, msb-2
mux2: mux8to1 generic map (n => 258)
              port map (pad, s4_a, s5_a, s6_a, s7_a, s8_a, s9_a, s9_a, mux2_sel, mux2_out);

s4: CLA_258bit port map (mux1_out, mux2_out, '1', s4_out);

reg5: reg generic map ( n => 258 )
          port map ( s4_out , clock, or_out, reset, reg5_out );

done <= not(or_out);

--- OUTPUT DINAMIC CONTROL ---

s10_a <= reg5_out(256 downto 0);
s10_b <= not('0' & p);

s10: CLA_257bit port map (s10_a, s10_b, '1', s10_out);

mux3_in0 <= s10_out(255 downto 0);
mux3_in1 <= reg5_out(255 downto 0);
mux3_sel <= s10_out(256);

mux3: mux2to1 generic map (n => 256)
              port map (mux3_in0, mux3_in1, mux3_sel, mux3_out);

mult_out <= mux3_out;
 end architecture;
