library ieee;
use ieee.std_logic_1164.all;
use ieee.numeric_std.all;

entity modular_inverter_fsm is

port( q, start, reset, clock: in std_logic;
      mux1_sel, mux2_sel, mux3_sel, mux4_sel, res, don : out std_logic;
      regQ_load, regR_load, regS_load, regT_load, reg1_load, reg2_load, reg3_load, reg4_load : out std_logic);

end entity;

architecture structural of modular_inverter_fsm is

-------machine state----------
type state_type is (IDLE,LOAD,A,B,DONE); --stati
signal present_state, next_state: state_type; --stato corrente, stato futuro

--..............................................SIGNAL.......................................................

--there are no signal because there is only the fsm and there is not the datapath inside this block

--.............................................COMPONENT.....................................................

--there are no signal because there is only the fsm and there is not the datapath inside this block

--.................................................FSM........................................................
 begin

------------state update-------------
update_state: process(clock, reset)
begin

 if reset='1' then present_state <= IDLE;  --reset active high
 elsif (clock'event and clock='1') then present_state <= next_state;
 end if;

end process;

---------state transition------------
state_transition: process(clock, present_state)
begin
case present_state is

 when IDLE => if start = '1' then next_state <= LOAD; else next_state <= IDLE; end if;
 when LOAD => next_state <= A;
 when A => next_state <= B;
 when B => if q = '1' then next_state <= DONE; else next_state <= B; end if;
 when DONE => next_state <= IDLE;
 when others => next_state<=IDLE;

end case;
end process;

---------------output-------------
output: process(present_state)
begin
 
--definisco un valore di default di ogni segnale di controllo
mux1_sel <= '0'; mux2_sel <= '0'; mux3_sel <= '0'; mux4_sel <= '0'; regQ_load <= '0'; regR_load <= '0';
regS_load <= '0'; regT_load <= '0'; reg1_load <= '0'; reg2_load <= '0'; reg3_load <= '0'; reg4_load <= '0'; res <= '0'; don <= '0';

--per ogni stato definisco solo i segnali con valore diverso da quello di default
case present_state is

 when IDLE => res <= '1' ;
 when LOAD => regQ_load <= '1'; regR_load <= '1'; regS_load <= '1'; regT_load <= '1';
 when A => mux1_sel <= '1'; mux2_sel <= '1'; mux3_sel <= '1'; mux4_sel <= '1'; regQ_load <= '1'; regR_load <= '1'; regS_load <= '1';
           regT_load <= '1'; reg1_load <= '1'; reg2_load <= '1'; reg3_load <= '1';
 when B => mux1_sel <= '1'; mux2_sel <= '1'; mux3_sel <= '1'; mux4_sel <= '1'; regQ_load <= '1'; regR_load <= '1'; regS_load <= '1';
           regT_load <= '1'; reg1_load <= '1'; reg2_load <= '1'; reg3_load <= '1'; reg4_load <= '1'; 
 when DONE => don <= '1';

end case;
end process;
 
--..............................................DATAPATH.......................................................

--there are no signal because there is only the fsm and there is not the datapath inside this block
      
                  
end architecture;
