library ieee;
use ieee.std_logic_1164.all;
use ieee.numeric_std.all;
use work.curve_parameter_pkg.all;

 entity modular_inverter_datapath is

    port( B : in std_logic_vector(255 downto 0);
          clock, reset, start : in std_logic;          --reset active high 
          inv_out : out std_logic_vector(255 downto 0);
          q, done : out std_logic;
          mux1_sel, mux2_sel, mux3_sel, mux4_sel : in std_logic;
          regQ_load, regR_load, regS_load, regT_load, reg1_load, reg2_load, reg3_load, reg4_load : in std_logic);

 end entity;

 architecture behavioural of modular_inverter_datapath is

signal mux1_in0, mux1_in1, mux1_out : std_logic_vector(257 downto 0);
signal mux2_in0, mux2_in1, mux2_out : std_logic_vector(257 downto 0);
signal mux3_in0, mux3_in1, mux3_out : std_logic_vector(257 downto 0);
signal mux4_in0, mux4_in1, mux4_out : std_logic_vector(257 downto 0);
signal mux5_in00, mux5_in01, mux5_in10, mux5_in11, mux5_out : std_logic_vector(257 downto 0);
signal mux6_in00, mux6_in01, mux6_in10, mux6_in11, mux6_out : std_logic_vector(257 downto 0);
signal mux5_sel, mux6_sel : std_logic_vector(1 downto 0);
signal mux7_in0, mux7_in1 , mux7_in2, mux7_in3, mux7_in4, mux7_out : std_logic_vector(257 downto 0);
signal mux8_in0, mux8_in1 , mux8_in2, mux8_in3, mux8_in4, mux8_out : std_logic_vector(257 downto 0);
signal mux7_sel, mux8_sel : std_logic_vector(3 downto 0);
signal mux9_in00, mux9_in01, mux9_in10, mux9_in11, mux9_out : std_logic_vector(257 downto 0);
signal mux9_sel : std_logic_vector(1 downto 0); 

signal regQ_out, regR_out, regS_out, regT_out : std_logic_vector(257 downto 0);

signal s1_a, s1_b, s1_out, s2_a, s2_b, s2_out, s3_a, s3_b, s3_out : std_logic_vector(257 downto 0);
signal s4_a, s4_b, s4_out, s5_a, s5_b, s5_out, s6_a, s6_b, s6_out : std_logic_vector(257 downto 0);
signal s7_a, s7_b, s7_out, s8_a, s8_b, s8_out, s9_a, s9_b, s9_out, s10_a, s10_b, s10_out  : std_logic_vector(257 downto 0);

signal reg1_out, reg2_out, reg3_out : std_logic_vector(257 downto 0);
signal reg4_in : std_logic_vector(255 downto 0);

 component mux4to1 is
    generic( n : integer);
    port( in_00, in_01, in_10, in_11 : in std_logic_vector(n-1 downto 0);
          sel : in std_logic_vector(1 downto 0);
          data_out : out std_logic_vector(n-1 downto 0));
 end component;

 component mux16to1_1_modified is
    generic( n : integer);
    port( in_0, in_1, in_2, in_3, in_4 : in std_logic_vector(n-1 downto 0);
          sel : in std_logic_vector(3 downto 0);
          data_out : out std_logic_vector(n-1 downto 0));
 end component;

 component mux16to1_2_modified is
    generic( n : integer);
    port( in_0, in_1, in_2, in_3, in_4 : in std_logic_vector(n-1 downto 0);
          sel : in std_logic_vector(3 downto 0);
          data_out : out std_logic_vector(n-1 downto 0));
 end component;

 component mux2to1 is
    generic(n : integer);
    port( in_0, In_1 : in std_logic_vector (n-1 downto 0);
          sel: in std_logic;
          data_out : out std_logic_vector (n-1 downto 0));
 end component;

 component reg is
     generic( n: integer);
     port ( data_in : in std_logic_vector( n-1 downto 0);
            clock, en, reset: in std_logic;                 --reset active high
            data_out : out std_logic_vector( n-1 downto 0));
 end component;

component CLA_258bit is  --------- 259 BIT input/output ---------
    port( a_in,b_in : in std_logic_vector( 257 downto 0);
          c_in : in std_logic;
          s : out std_logic_vector( 257 downto 0));
end component;

  begin

mux1_in0 <= '0' & '0' & B;
mux1_in1 <= mux5_out;
mux1: mux2to1 generic map (n => 258)
              port map (mux1_in0, mux1_in1, mux1_sel, mux1_out);

              --- 1 ---
mux2_in0 <= "000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000001";
mux2_in1 <= mux7_out;
mux2: mux2to1 generic map (n => 258)
              port map (mux2_in0, mux2_in1, mux2_sel, mux2_out);

mux3_in0 <= '0' & '0' & p;
mux3_in1 <= mux6_out;
mux3: mux2to1 generic map (n => 258)
              port map (mux3_in0, mux3_in1, mux3_sel, mux3_out);

              --- 0 ---
mux4_in0 <= "000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000";
mux4_in1 <= mux8_out;
mux4: mux2to1 generic map (n => 258)
              port map (mux4_in0, mux4_in1, mux4_sel, mux4_out);


regQ: reg generic map ( n => 258 )
          port map ( mux1_out , clock, regQ_load, reset, regQ_out );

regR: reg generic map ( n => 258 )
          port map ( mux3_out , clock, regR_load, reset, regR_out );

regS: reg generic map ( n => 258 )
          port map ( mux2_out , clock, regS_load, reset, regS_out );

regT: reg generic map ( n => 258 )
          port map ( mux4_out , clock, regT_load, reset, regT_out );

s1_a <= regQ_out;
s1_b <= not(regR_out);
s1: CLA_258bit port map (s1_a, s1_b, '1', s1_out);

s2_a <= regR_out;
s2_b <= not(regQ_out);
s2: CLA_258bit port map (s2_a, s2_b, '1', s2_out);

s3_a <= regS_out;
s3_b <= '0' & '0' & p;
s3: CLA_258bit port map (s3_a, s3_b, '0', s3_out);

s4_a <= regS_out;
s4_b <= not(regT_out);
s4: CLA_258bit port map (s4_a, s4_b, '1', s4_out);

s5_a <= s3_out;
s5_b <= not(regT_out);
s5: CLA_258bit port map (s5_a, s5_b, '1', s5_out);

s6_a <= s8_out;
s6_b <= not(regS_out);
s6: CLA_258bit port map (s6_a, s6_b, '1', s6_out);

s7_a <= regT_out;
s7_b <= not(regS_out);
s7: CLA_258bit port map (s7_a, s7_b, '1', s7_out);

s8_a <= '0' & '0' & p;
s8_b <= regT_out;
s8: CLA_258bit port map (s8_a, s8_b, '0', s8_out);

mux5_sel <= regQ_out(0) & s1_out(257);
mux5_in00 <= '0' & regQ_out(257 downto 1);
mux5_in01 <= '0' & regQ_out(257 downto 1);
mux5_in10 <= s1_out;
mux5_in11 <= regQ_out;
mux5: mux4to1 generic map (n => 258)
              port map ( mux5_in00, mux5_in01 , mux5_in10, mux5_in11, mux5_sel, mux5_out);


mux6_sel <=  s1_out(257) & regR_out(0);
mux6_in00 <= '0' & regR_out(257 downto 1);
mux6_in10 <= '0' & regR_out(257 downto 1);
mux6_in01 <= regR_out;
mux6_in11 <= s2_out;
mux6: mux4to1 generic map (n => 258)
              port map ( mux6_in00, mux6_in01 , mux6_in10, mux6_in11, mux6_sel, mux6_out);


mux7_in0 <= '0' & s3_out(257 downto 1);
mux7_in1 <= '0' & regS_out (257 downto 1);
mux7_in2 <= regS_out;
mux7_in3 <= s4_out;
mux7_in4 <= s5_out;
mux7_sel <= regS_out(0) & regQ_out(0) & s1_out(257) &  s4_out(257);
mux7: mux16to1_1_modified generic map (n => 258)
              port map (mux7_in0, mux7_in1 , mux7_in2, mux7_in3, mux7_in4, mux7_sel, mux7_out);


mux8_in0 <= '0' & s8_out(257 downto 1);
mux8_in1 <= '0' & regT_out (257 downto 1);
mux8_in2 <= regT_out;
mux8_in3 <= s7_out;
mux8_in4 <= s6_out;
mux8_sel <= s4_out(257) & s1_out(257) & regR_out(0) & regT_out(0);
mux8: mux16to1_2_modified generic map (n => 258)
              port map (mux8_in0, mux8_in1 , mux8_in2, mux8_in3, mux8_in4, mux8_sel, mux8_out);

-- result computation

reg1: reg generic map ( n => 258 )
          port map ( mux5_out , clock, '1', reset, reg1_out ); 

reg2: reg generic map ( n => 258 )
          port map ( mux7_out , clock, '1', reset, reg2_out ); 

reg3: reg generic map ( n => 258 )
          port map ( mux7_out , clock, '1', reset, reg3_out ); 

s9_a <= reg1_out;
s9_b <= not("000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000010");
s9: CLA_258bit port map (s9_a, s9_b, '1', s9_out);

s10_a <= reg2_out;
s10_b <= not('0' & '0' & p);
s10: CLA_258bit port map (s10_a, s10_b, '1', s10_out);

mux9_in00 <= "000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000";
mux9_in01 <= s10_out;
mux9_in10 <= "000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000";
mux9_in11 <= reg3_out;
mux9_sel <= s10_out(257) & s9_out(257);
mux9: mux4to1 generic map (n => 258)
              port map (mux9_in00, mux9_in01, mux9_in10, mux9_in11, mux9_sel, mux9_out);

q <= s9_out(257);

reg4_in <= mux9_out(255 downto 0);
reg4: reg generic map ( n => 256 )
          port map ( reg4_in , clock, reg4_load, reset, inv_out );

done <= s9_out(257);



 end architecture;
