library ieee;
use ieee.std_logic_1164.all;
use ieee.numeric_std.all;
use work.curve_parameter_pkg.all;

 entity modular_inverter is

    port( B : in std_logic_vector(255 downto 0);
          clock, reset, start: in std_logic;          --reset active high 
          inv_out : out std_logic_vector(255 downto 0);
          done : out std_logic);

 end entity;

 architecture behavioural of modular_inverter is

signal mux1_sel, mux2_sel, mux3_sel, mux4_sel, q, res, don, datapath_done : std_logic;
signal regQ_load, regR_load, regS_load, regT_load, reg1_load, reg2_load, reg3_load, reg4_load : std_logic;


 component modular_inverter_datapath is
    port( B : in std_logic_vector(255 downto 0);
          clock, reset, start : in std_logic;          --reset active high 
          inv_out : out std_logic_vector(255 downto 0);
          q, done : out std_logic;
          mux1_sel, mux2_sel, mux3_sel, mux4_sel : in std_logic;
          regQ_load, regR_load, regS_load, regT_load, reg1_load, reg2_load, reg3_load, reg4_load : in std_logic);
 end component;

component modular_inverter_fsm is
port( q, start, reset, clock: in std_logic;
      mux1_sel, mux2_sel, mux3_sel, mux4_sel, res, don : out std_logic;
      regQ_load, regR_load, regS_load, regT_load, reg1_load, reg2_load, reg3_load, reg4_load : out std_logic);
end component;

  begin

datapath : modular_inverter_datapath port map(B, clock, res, start, inv_out, q, datapath_done, mux1_sel, mux2_sel, mux3_sel, mux4_sel, 
          regQ_load, regR_load, regS_load, regT_load, reg1_load, reg2_load, reg3_load, reg4_load );

fsm : modular_inverter_fsm port map(q, start, reset, clock, mux1_sel, mux2_sel, mux3_sel, mux4_sel, res, don, 
      regQ_load, regR_load, regS_load, regT_load, reg1_load, reg2_load, reg3_load, reg4_load );

done <= don;

 end architecture;
