library IEEE;
use IEEE.STD_LOGIC_1164.ALL;

package curve_parameter_pkg is

          ---- Edward25519 ---- 
     ---- aX^2+Y^2 = 1+dX^2Y^2 ----
   
  ---  field dimension ---

    --- 256 bit ---
    constant p : std_logic_vector (255 downto 0) := x"7fffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffed";
    -- 0111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111101101
    
    --- 258 bit --- multiples of p
    constant pX2 : std_logic_vector (257 downto 0) := "001111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111011010";
    constant pX3 : std_logic_vector (257 downto 0) := "010111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111000111";
    constant pX4 : std_logic_vector (257 downto 0) := "011111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111110110100";
    constant pX5 : std_logic_vector (257 downto 0) := "100111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111110100001";
    constant pX6 : std_logic_vector (257 downto 0) := "101111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111110001110";

  ---------- a ----------

    constant a : std_logic_vector (255 downto 0) := x"7fffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffec";

  ---------- d ----------

    constant d : std_logic_vector (255 downto 0) := x"52036cee2b6ffe738cc740797779e89800700a4d4141d8ab75eb4dca135978a3";

  ------- base point -----

    constant Gx : std_logic_vector (255 downto 0) := x"216936D3CD6E53FEC0A4E231FDD6DC5C692CC7609525A7B2C9562D608F25D51A";
    constant Gy : std_logic_vector (255 downto 0) := x"6666666666666666666666666666666666666666666666666666666666666658";
    constant Gz : std_logic_vector (255 downto 0) := x"0000000000000000000000000000000000000000000000000000000000000001";  

   -- doubling base point --

    constant Gx2 : std_logic_vector (255 downto 0) := x"31241ddb9a7c254aea224b87b7b0f909886ec1ddfa71625b7aba864c18300a57";
    constant Gy2 : std_logic_vector (255 downto 0) := x"3324984c6cc933db69b782fc3ac951f60a47aa662bbe321c924b2cd95e2d7fd7";  
    constant Gz2 : std_logic_vector (255 downto 0) := x"6986c5796b577c574098d1fa3b426292ebd36100339299d16374a93d0278de6b";    
    
    
end curve_parameter_pkg;
