
library IEEE;
use IEEE.STD_LOGIC_1164.ALL;
use IEEE.STD_LOGIC_ARITH.ALL;
use IEEE.STD_LOGIC_UNSIGNED.ALL;

entity Counter_modified is
    Port ( clock, reset, en : in std_logic;
           count : out std_logic_vector(7 downto 0));
end entity;

architecture Behavioral of Counter_modified is
    signal counter_reg : std_logic_vector(7 downto 0);
begin
    process(clock, reset)
    begin
        if reset = '1' then
            counter_reg <= "00000001"; --reset to 1, not to 0
        elsif (clock'event and clock='1' and en='1')  then
            counter_reg <= counter_reg + 1;
        end if;
    end process;

    count <= counter_reg;
end architecture;
