library ieee;
use ieee.std_logic_1164.all;
use ieee.numeric_std.all;
use work.curve_parameter_pkg.all;

 entity adder_CLA258bit is

    port( A,B : in std_logic_vector(255 downto 0);
          clock, reset, start : in std_logic;          --reset active high 
          sum_out : out std_logic_vector(255 downto 0)); 

 end entity;

 architecture behavioural of adder_CLA258bit is

signal reg1_out, reg2_out, reg3_in : std_logic_vector(255 downto 0);
signal s1_a, s1_b, s2_a, s2_b, s1_out, s2_out : std_logic_vector(257 downto 0);


 component reg is
     generic( n: integer);
     port ( data_in : in std_logic_vector( n-1 downto 0);
            clock, en, reset: in std_logic;                 --reset active high
            data_out : out std_logic_vector( n-1 downto 0));
 end component;

component CLA_258bit is  ----- 257 BIT input/output -------
    port( a_in,b_in : in std_logic_vector( 257 downto 0);
          c_in : in std_logic;
          s : out std_logic_vector( 257 downto 0));
end component;

  begin
 
reg1: reg generic map ( n => 256 )
          port map ( A , clock, start, reset, reg1_out );
s1_a <= '0' & '0' & reg1_out;

reg2: reg generic map ( n => 256 )
          port map ( B , clock, start, reset, reg2_out );
s1_b <= '0' & '0' & reg2_out;

s1: CLA_258bit port map (s1_a, s1_b, '0', s1_out);

reg3_in <= s1_out(255 downto 0);

reg3: reg generic map ( n => 256 )
          port map ( reg3_in , clock, start, reset, sum_out );  


 end architecture;

