
library ieee;
use ieee.std_logic_1164.all;
use ieee.numeric_std.all;
use work.curve_parameter_pkg.all;

 entity VIVADO_point_doubling is

    port( A,B : in std_logic_vector(255 downto 0);
          clock, reset, start : in std_logic;          --reset active high
          done : out std_logic; 
          sum_out : out std_logic_vector(255 downto 0)); 

 end entity;

 architecture behavioural of VIVADO_point_doubling is

signal reg1_out, reg2_out, reg3_in, g, h, j : std_logic_vector(255 downto 0);


 component reg is
     generic( n: integer);
     port ( data_in : in std_logic_vector( n-1 downto 0);
            clock, en, reset: in std_logic;                 --reset active high
            data_out : out std_logic_vector( n-1 downto 0));
 end component;

component point_doubling_RADIX4 is
    port( x1, y1, z1 : in std_logic_vector(255 downto 0);
          clock, reset, start : in std_logic;          --reset active high 
          done : out std_logic;
          x2,y2,z2 : out std_logic_vector( 255 downto 0));
 end component;

  begin
 
reg1: reg generic map ( n => 256 )
          port map ( A , clock, start, reset, reg1_out );


reg2: reg generic map ( n => 256 )
          port map ( B , clock, start, reset, reg2_out );

point_add : point_doubling_RADIX4 port map (reg1_out, reg2_out, reg2_out, clock, reset, start, done, g,h,j  );

reg3: reg generic map ( n => 256 )
          port map ( g , clock, start, reset, sum_out );  


 end architecture;
