library IEEE;
use IEEE.STD_LOGIC_1164.ALL;
use IEEE.STD_LOGIC_ARITH.ALL;
use IEEE.STD_LOGIC_UNSIGNED.ALL;

entity OR_256bit is
    Port ( input_bits : in STD_LOGIC_VECTOR(255 downto 0);
           or_output : out STD_LOGIC);
end entity;

architecture Behavioral of OR_256bit is
    signal intermediate_results : STD_LOGIC_VECTOR(83 downto 0);
begin
    -- First level of OR gates
    gen_first_level: for i in 0 to 63 generate
        intermediate_results(i) <= input_bits(i*4) OR input_bits(i*4 + 1) OR input_bits(i*4 + 2) OR input_bits(i*4 + 3);
    end generate;

    -- Second level of OR gates
    gen_second_level: for i in 0 to 15 generate
        intermediate_results(64 + i) <= intermediate_results(i*4) OR intermediate_results(i*4 + 1) OR intermediate_results(i*4 + 2) OR intermediate_results(i*4 + 3);
    end generate;

    -- Third level of OR gates
    gen_third_level: for i in 0 to 3 generate
        intermediate_results(80 + i) <= intermediate_results(64 + i*4) OR intermediate_results(64 + i*4 + 1) OR intermediate_results(64 + i*4 + 2) OR intermediate_results(64 + i*4 + 3);
    end generate;

    -- Fourth level of OR gates
        or_output <= intermediate_results(80) OR intermediate_results(81) OR intermediate_results(82) OR intermediate_results(83);

end architecture;

